/*
 * dia_SrvHandler_ReadSystemOperationTime.cpp
 *
 *  Created on: Mar 26, 2019
 *      Author: hgr6kor
 */
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef _INCLUDED_DIA_SRVHANDLER_READ_SYSTEM_OPERATION_TIME_H_
#include "dia_SrvHandler_ReadSystemOperationTime.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 4

dia_SrvHandler_ReadSystemOperationTime::dia_SrvHandler_ReadSystemOperationTime ( tCString name, tU8 sid, tU16 did )
: dia_ServiceHandlerUDS(name,sid, did /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadSystemOperationTime::dia_SrvHandler_ReadSystemOperationTime(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadSystemOperationTime::~dia_SrvHandler_ReadSystemOperationTime ( tVoid )
{
	DIA_TR_INF("dia_SrvHandler_ReadSystemOperationTime::~dia_SrvHandler_ReadSystemOperationTime(tVoid)");

	   _BP_TRY_BEGIN
	    {
	       (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
	    }
	    _BP_CATCH_ALL
	    {
	        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadSystemOperationTime::~dia_SrvHandler_ReadSystemOperationTime !!!");
	        NORMAL_M_ASSERT_ALWAYS();
	    }
	    _BP_CATCH_END

}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_ReadSystemOperationTime::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadSystemOperationTime::vProcessRequest");

     tBool errorDetected = TRUE;

     dia_ISpmTimerIntervall* pInterface = 0;
     if ( querySysAdapterInterface<dia_ISpmTimerIntervall>(&pInterface) == DIA_SUCCESS )
     {
        if ( pInterface )
        {
           (tVoid) setSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
           if ( pInterface->getSpmTimerIntervall(DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER) == DIA_SUCCESS )
           {
              errorDetected = FALSE;
           }
        }
     }

     if ( errorDetected )
     {
        (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
        DIA_TR_ERR(" dia_SrvHandler_ReadSystemOperationTime ---  SEND TO SPM SERVER FAILED!!!!");
        vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
     }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_ReadSystemOperationTime::vOnSpmTimerIntervall ( dia_eSpmTimerIntervallID id, tU32 timerIntervall )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadSystemOperationTime::vOnSpmTimeValue");

   (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);

   if (id == DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER)
   {
      DIA_TR_INF("dia_SrvHandler_ReadSystemOperationTime::vOnSpmTimerIntervall SUCCESSFUL");

      // Sending back the Positive Response
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (timerIntervall >> 24)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, ((tU8) (timerIntervall >> 16)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 2, ((tU8) (timerIntervall >> 8)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 3, ((tU8) (timerIntervall)));

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_ReadSystemOperationTime::vOnSpmTimerIntervall FAIL");
      // Sending back the Negative Response
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

