#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif
#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif
#ifndef __DIA_SRVHANDLER_READOVERALLCISSWVERSION_H__
#include "dia_SrvHandler_ReadOverallCISSWVersion.h"
#endif
#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif
#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif
#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif
#include <limits.h>
#include <stdlib.h>
//#include "gtest/gtest.h"

//#include "dia_osal_mock.h"
//#include "mocks/dia_MockDataDownloadManager.h"
//#include "mocks/dia_MockUploadDownloadStrategyFiles.h"
//#include "mocks/dia_MockConfigManager.h"
#include "common/framework/datadownload/dia_UploadDownloadStrategyFiles.h"
#include "common/framework/utils/dia_utilities.h"
#include "common/framework/application/dia_File.h"
#define DIA_C_U8_STATUS_NOT_CONNECTED       ( (tU8) 0x00)
#define DIA_C_U8_STATUS_CONNECTED           ( (tU8) 0x01)
#define DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))
#define DATA_LENGTH                             ((tU16) (30))

#define DATA_BUFFERLENGTH                    ((tU16) (52))

static const std::string File_Path("/var/opt/bosch/persistent/registry/overallCISSWversion.reg");
tU8 n,m;

//-------------------------------------------------------------------------------

dia_SrvHandler_ReadOverallCISSWVersion::dia_SrvHandler_ReadOverallCISSWVersion ( tCString name, tU8 sid, tU16 did )
: dia_ServiceHandlerUDS(name,sid,did)
{
	dia_tclFnctTrace trc("dia_SrvHandler_ReadOverallCISSWVersion::dia_SrvHandler_ReadOverallCISSWVersion(void)");
}

//----------------------------------------------------------------------------------------------------

dia_SrvHandler_ReadOverallCISSWVersion::~dia_SrvHandler_ReadOverallCISSWVersion ( void )
{}
//----------------------------------------------------------------------------------------------------
void
dia_SrvHandler_ReadOverallCISSWVersion::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
	dia_tclFnctTrace oTrace("dia_SrvHandler_ReadOverallCISSWVersion::vProcessRequest()");
	tU8 u8ConnetionStatus = DIA_C_U8_STATUS_NOT_CONNECTED;
	tU8 i;
	FILE* pFile = fopen (File_Path.c_str(),"r" );
	//std::string Buffer1; 
    char Buffer1 [DATA_BUFFERLENGTH] ={0};
	std::vector<char> Buffer2;
    //char* Buffer3;	
	if(pFile != NULL)
	{
		DIA_TR_INF("OABR Connection Status file is: %s:", File_Path.c_str());
		size_t usedSize = fread(Buffer1,sizeof(Buffer1),1,pFile);
		//std::vector<std::string> Buffer(Buffer1.begin(), Buffer1.end());
		
		fclose (pFile); 
		for (i=0;i<sizeof(Buffer1);i++)
		{
		        DIA_TR_INF("dia_SrvHandler_ReadOverallCISSWVersion::value of version of buffer1: 0x%02x",Buffer1[i]);
				if(Buffer1[i] == '=')
				{
					for (n = i+1;n<(sizeof(Buffer1));n++)
					{
						
						DIA_TR_INF("dia_SrvHandler_ReadOverallCISSWVersion::value of version of buffer1: 0x%02x",Buffer1[n]);
						Buffer2.push_back((Buffer1[n]));
                        DIA_TR_INF("dia_SrvHandler_ReadOverallCISSWVersion::value of version of buffer2: 0x%02x",Buffer2[n]);						
					}
					break;			
		        }
				else
				{
					DIA_TR_INF("Expected data not found");
				}
					
	    }
	            
    }
	else
    {
        DIA_TR_ERR("!!! readFileToBuffer => fopen FAILED");
    }
	oDiagMsgBuffer().vSetPosResp();
	oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH + Buffer2.size()));
	
    for (i=0;i<=Buffer2.size();i++)
    {
		
        (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH + i), (Buffer2[i]));
    }
    vResReadyAndQuit();
}
