/*
 * dia_SrvHandler_ReadMileageValue.h
 *
 *  Created on: 19.11.2015
 *      Author: gpu2kor
 */
//TTFis: DIA_REQ UDS 04 22 F0 D0
#ifndef DIA_SRVHANDLER_READ_MILEAGEVALUE_H_
#define DIA_SRVHANDLER_READ_MILEAGEVALUE_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

// forward declaration
class csm_tclCsmAccessUser;

class dia_SrvHandler_ReadMileageValue
   : public dia_ServiceHandlerUDS
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadMileageValue);

public:
   //! class constructor
   dia_SrvHandler_ReadMileageValue ( void );
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_ReadMileageValue(void);

private:
   csm_tclCsmAccessUser*   m_pCsmAccessUser; // pointer to CMS_proxy object

   //! Read CAN signals and send positive/negative response or do nothing ;).
   virtual void getMileage();

   //! Send positive response with 3 bytes of specified mileage
   virtual void sendPosResp(tU32 mileage);

   static constexpr float DIAG_MILE_TO_KM_CONV_RATIO = 1.609344f;
};

#endif /* DIA_SRVHANDLER_READ_MILEAGEVALUE_H_ */
