/*
 * dia_SrvHandler_ReadHWSWVersion.cpp
 *
 *  Created on: 28.09.2015
 *      Author: wgl2hi
 */
// TTFis:\> DIA_REQ UDS 04 22 DE 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif
#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif
#ifndef __DIA_SRVHANDLER_READHWSWVERSION_H__
#include "dia_SrvHandler_ReadHWSWVersion.h"
#endif

#define DATA_START  3
#define DATA_LENGTH 39

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadHWSWVersion::dia_SrvHandler_ReadHWSWVersion ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadHWSWVersion", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_HWSW_VERSION ),
      m_hardwareVersion(),
      m_softwareVersion(),
      m_mapVersion()
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadHWSWVersion::dia_SrvHandler_ReadHWSWVersion(void)");

   /* Create default format for member variables which is not possible with out compiler settings */
   for(tU8 i=0; i<DIA_PROP_CM_ECU_HW_VERSION_SIZE; i++)
   {
      m_hardwareVersion[i] = '0';
   }

   /* Customer SW Version */
   for(tU8 i=0; i<DIA_PROP_CM_CUSTOMER_SW_VERSION_SIZE; i++)
   {
      m_softwareVersion[i] = '0';
   }

   /* Map Version */
   for(tU8 i=0; i<DIA_PROP_CM_ECU_MAP_VERSION_SIZE; i++)
   {
      m_mapVersion[i] = '0';
   }
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadHWSWVersion::~dia_SrvHandler_ReadHWSWVersion ( void )
{
    // no try/catch necessary
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadHWSWVersion::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadHWSWVersion::vProcessRequest");

   tBool errorDetected = FALSE;

   /* ECU HW Version */
   if(dia_getPropertySize(DIA_PROP_CM_ECU_HW_VERSION)==DIA_PROP_CM_ECU_HW_VERSION_SIZE)
   {
      if (DIA_SUCCESS != dia_getProperty(DIA_PROP_CM_ECU_HW_VERSION, m_hardwareVersion, DIA_PROP_CM_ECU_HW_VERSION_SIZE))
      {
         // if the KDS content isn't available "000" shall be returned.
         DIA_TR_INF("dia_SrvHandler_ReadHWSWVersion:: hardware version empty - set default.");
         (void)::memset(m_hardwareVersion, 0, sizeof(tU8)*DIA_PROP_CM_ECU_HW_VERSION_SIZE);//Coverity fix(CID:19126)
      }
      DIA_TR_INF("dia_SrvHandler_ReadHWSWVersion:: hardware version = 0x%02x 0x%02x 0x%02x .", m_hardwareVersion[0], m_hardwareVersion[1], m_hardwareVersion[2]);
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_ReadHWSWVersion:: hardware version size ERROR IS=%d, Expected=%d !", dia_getPropertySize(DIA_PROP_CM_ECU_HW_VERSION), DIA_PROP_CM_ECU_HW_VERSION_SIZE);
      errorDetected = TRUE;
   }

   /* Customer SW Version */
   if (dia_getPropertySize(DIA_PROP_VERSION_SW_CUSTOMER) == DIA_PROP_CM_CUSTOMER_SW_VERSION_SIZE) // ending /0 in string
   {
      std::vector<tU8> vecSoftwareVersion;

      if (DIA_SUCCESS == dia_getProperty(DIA_PROP_VERSION_SW_CUSTOMER, vecSoftwareVersion)) // ending /0 in string
      {
         for (tU32 i = 0; i < DIA_PROP_CM_CUSTOMER_SW_VERSION_SIZE; i++)
         {
            m_softwareVersion[i] = vecSoftwareVersion[i];
         }
      }
      else
      {
         // If the key isn't available "0000" shall be returned.
         DIA_TR_INF("dia_SrvHandler_ReadHWSWVersion:: software version empty - set default.");
         (void)::memset(m_softwareVersion, 0, sizeof(tU8)*DIA_PROP_CM_CUSTOMER_SW_VERSION_SIZE);//Coverity fix(CID:19126)
      }

      DIA_TR_INF("dia_SrvHandler_ReadHWSWVersion:: software version = 0x%02x 0x%02x 0x%02x 0x%02x.", m_softwareVersion[0], m_softwareVersion[1], m_softwareVersion[2], m_softwareVersion[3]);
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_ReadHWSWVersion:: software version size ERROR IS=%d, Expected=%d !", dia_getPropertySize(DIA_PROP_VERSION_SW_CUSTOMER), DIA_PROP_CM_CUSTOMER_SW_VERSION_SIZE); // no ending /0 in string
      errorDetected = TRUE;
   }

   /* Map Version */
#if 0
   if (dia_getPropertySize(DIA_PROP_CM_ECU_SERIAL_NR) == DIA_PROP_CM_ECU_MAP_VERSION_SIZE)
   {
      if (DIA_SUCCESS != dia_getProperty(DIA_PROP_CM_MAP_VERSION, m_mapVersion, DIA_PROP_CM_ECU_MAP_VERSION_SIZE))
      {
         DIA_TR_INF("dia_SrvHandler_ReadHWSWVersion:: map version = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x \
                    0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x \
                    0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x.", \
            m_mapVersion[0], m_mapVersion[1], m_mapVersion[2], m_mapVersion[3], m_mapVersion[4], m_mapVersion[5], m_mapVersion[6], \
            m_mapVersion[7], m_mapVersion[8], m_mapVersion[9], m_mapVersion[10], m_mapVersion[11], m_mapVersion[12], m_mapVersion[13] \
            m_mapVersion[14], m_mapVersion[15], m_mapVersion[16], m_mapVersion[17], m_mapVersion[18], m_mapVersion[19], m_mapVersion[20], \
            m_mapVersion[21], m_mapVersion[22], m_mapVersion[23], m_mapVersion[24], m_mapVersion[25], m_mapVersion[26] m_mapVersion[27], \
            m_mapVersion[28], m_mapVersion[29], m_mapVersion[30], m_mapVersion[31]);
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_ReadHWSWVersion:: Map Version size ERROR IS=%d, Expected=%d !", dia_getPropertySize(DIA_PROP_CM_MAP_VERSION), DIA_PROP_CM_ECU_MAP_VERSION_SIZE);
      errorDetected = TRUE;
   }
#endif

   if ( errorDetected == TRUE )
   {
      DIA_TR_ERR("dia_SrvHandler_ReadHWSWVersion::vProcessRequest --- READING PROPERTIES FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_ReadHWSWVersion::vProcessRequest - Data ready to send.");
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      tU8 currPosition = 0;
      /* ECU HW Version */
      for(tU8 i=0; i<DIA_PROP_CM_ECU_HW_VERSION_SIZE; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START + currPosition, ((tU8) m_hardwareVersion[i]));
         currPosition++;
      }

      /* Customer SW Version */
      for(tU8 i=0; i<DIA_PROP_CM_CUSTOMER_SW_VERSION_SIZE; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START + currPosition, ((tU8) m_softwareVersion[i]));
         currPosition++;
      }

      /* Map Version */
      for(tU8 i=0; i<DIA_PROP_CM_ECU_MAP_VERSION_SIZE; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START + currPosition, ((tU8) m_mapVersion[i]));
         currPosition++;
      }

      vResReadyAndQuit();
   }
}
