/*
 * dia_SrvHandler_ReadExtendedDataByDTCNumber.h
 *
 *  Created on: 03.08.2015
 *      Author: wgl2hi
 */

#ifndef __DIA_SRVHANDLER_READEXTENDEDDATABYDTCNUMBER_H__
#define __DIA_SRVHANDLER_READEXTENDEDDATABYDTCNUMBER_H__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

class dia_SrvHandler_ReadExtendedDataByDTCNumber
    : public dia_ServiceHandlerUDS,
      public dia_IErrorLogListenerImpl
{
    DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandler_ReadExtendedDataByDTCNumber);
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadExtendedDataByDTCNumber);

public:
   //! class constructor
    dia_SrvHandler_ReadExtendedDataByDTCNumber ( const tU8 u8DID );
   //! class destructor
   virtual ~dia_SrvHandler_ReadExtendedDataByDTCNumber ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   virtual void vOnDiaglogGetExtendedDataByDTC (IErrorLogExtendedDataResult const& aExtendedData);
   virtual void vOnDiaglogGetSnapShotDataByDTC ( const tU32 dtc, const tU8 status, std::list<IErrorLogSnapshotDataResult>& snapshotList);

protected:
   
   void requestSnapshotData(tU8 u8RecordNumber);
   void requestExtendedData(tU8 u8RecordNumber);

   std::vector<tU8> result;
   tU8   m_u8StatusMask;
   tU8   m_u8RecordNumber;
   tU8   m_u8Progress;
};


#endif /* __DIA_SRVHANDLER_READEXTENDEDDATABYDTCNUMBER_H__ */
