/*
 * dia_SrvHandler_ReadEngineStoppedTime.h
 *
 *  Created on: Nov 2, 2016
 *      Author: OGM5KOR
 */

#ifndef DIA_SRVHANDLER_READENGINESTOPPEDTIME_H_
#define DIA_SRVHANDLER_READENGINESTOPPEDTIME_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_SrvHandler_ReadEngineStoppedTime
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadEngineStoppedTime);


public:
   //! class constructor
      dia_SrvHandler_ReadEngineStoppedTime();

   /**
     * \brief    	handle the received request
     *
     *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *				The SystemAdapter returns the Engine Stopped Time value
     */
   virtual tVoid vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested Degraded Counter Value
     *
     *				Function receives the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the Engine Stopped Time value to the tester.
     */

   virtual tVoid vOnGetEngineStoppedTime ( tU32 counter );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_ReadEngineStoppedTime();

};

#endif /* DIA_SRVHANDLER_READENGINESTOPPEDTIME_H_ */
