/*
 * dia_SrvHandler_ReadDegradedModeTime.cpp
 *
 *  Created on: Oct 24, 2016
 *      Author: OGM5KOR
 */

// TTFis: DIA_REQ UDS 04 22 10 10
#include "project/services/customer/dia_SrvHandler_ReadDegradedModeTime.h"

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadDegradedModeTime::dia_SrvHandler_ReadDegradedModeTime(tVoid) :
      dia_ServiceHandlerUDS("dia_SrvHandler_ReadDegradedModeTime", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_DEGRADED_MODE_TIME /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadDegradedModeTime::dia_SrvHandler_ReadDegradedModeTime(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadDegradedModeTime::~dia_SrvHandler_ReadDegradedModeTime(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadDegradedModeTime::~dia_SrvHandler_ReadDegradedModeTime !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

//-------------------------------------------------------------------------------

tVoid dia_SrvHandler_ReadDegradedModeTime::vProcessRequest(const std::vector<tVoid*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadDegradedModeTime::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getDegradedModeTime() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_ReadDegradedModeTime ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_ReadDegradedModeTime::vOnGetDegradedModeTime (tU32 itime)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadDegradedModeTime::vOnGetDegradedModeTime");

   DIA_TR_INF("dia_SrvHandler_ReadDegradedModeTime::vOnGetDegradedModeTime SUCCESSFUL");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   // Sending back the positive answer
#if 0
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 0,U32_BYTE1(itime));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 1,U32_BYTE2(itime));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 2,U32_BYTE3(itime));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 3,U32_BYTE4(itime));
#else
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 0,U32_BYTE3(itime));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 1,U32_BYTE4(itime));
#endif

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_ReadDegradedModeTime::vOnGetDegradedModeTime SUCCESSFUL");
}
