
/*!
 * \file       dia_SrvHandler_ReadCalibrationXtraData.h
 *
 * \brief      RDBI service to read first 10 bytes out of logical block 0. (AIVI-43057)
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef DIA_SRVHANDLER_READCALIBRATIONXTRADATA_H_
#define DIA_SRVHANDLER_READCALIBRATIONXTRADATA_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINECONTROL_LISTENER__
#include "common/interfaces/dia_IRoutineControlListener.h"
#endif


class dia_SrvHandler_ReadCalibrationXtraData
    : public dia_ServiceHandlerUDS,
      public dia_IRoutineControlListener
{
   //DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandler_ReadCalibrationXtraData);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadCalibrationXtraData);

public:
   dia_SrvHandler_ReadCalibrationXtraData ( void );

   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   //! dia_IRoutineControlListener
   virtual void vOnRoutineUpdate ( dia_Routine& routine );

protected:
   virtual ~dia_SrvHandler_ReadCalibrationXtraData ( void );

protected:
   tU16 mRoutineDid;
};


#endif /*DIA_SRVHANDLER_READCALIBRATIONXTRADATA_H_ */
