/*****************************************************************************************
*
* \file    dia_SrvHandler_ReadBTDevice.h
*
* \brief   Service Handler for Read BT Device
*
* \author  nce5kor	
*
* \date    02.12.2015
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __DIA_SRVHANDLER_READBTDEVICE_H__
#define __DIA_SRVHANDLER_READBTDEVICE_H__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST_LISTENER__
#include "project/interfaces/dia_IBluetoothMostListener.h"
#endif

class dia_SrvHandler_ReadBTDevice
   : public dia_ServiceHandlerUDS,
     public dia_IBluetoothMostListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadBTDevice);

public:
   //! class constructor
   dia_SrvHandler_ReadBTDevice ( void );
   //! class destructor
   virtual ~dia_SrvHandler_ReadBTDevice ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );
   //! a timeout has occurred
   virtual void vOnTimeout ( void );

   //
   // overloaded dia_IBluetoothListener methods
   //

   //! delivers information about the connected BT devices
   virtual void vOnBTConnectedDeviceList( tU8 numOfPairedDev, const dia_tBTExtendedDeviceInfo* devInfo);
};

#endif /* dia_SrvHandler_ReadBTDevice_H_ */
