/*
 * dia_SrvHandler_ReadAmplifierConnectionStatus.cpp
 *
 *  Created on: Jul 3, 2019
 *      Author: urm7kor
 */
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_SRVHANDLER_READAMPLIFIERCONNECTIONSTATUS_H_
#include "dia_SrvHandler_ReadAmplifierConnectionStatus.h"
#endif
#define DIA_C_U8_STATUS_NOT_CONNECTED       ( (tU8) 0x00)
#define DIA_C_U8_STATUS_CONNECTED           ( (tU8) 0x01)
static const tU16 DATA_START  = 3;
static const tU16 DATA_LENGTH = 1;
static const std::string File_Path("/sys/class/net/ethernet/carrier");

//-------------------------------------------------------------------------------

dia_SrvHandler_ReadAmplifierConnectionStatus::dia_SrvHandler_ReadAmplifierConnectionStatus ( tCString name, tU8 sid, tU16 did )
: dia_ServiceHandlerUDS(name,sid,did)
{
	dia_tclFnctTrace trc("dia_SrvHandler_ReadAmplifierConnectionStatus::dia_SrvHandler_ReadAmplifierConnectionStatus(tVoid)");
}

//----------------------------------------------------------------------------------------------------

dia_SrvHandler_ReadAmplifierConnectionStatus::~dia_SrvHandler_ReadAmplifierConnectionStatus ( tVoid )
{}
//----------------------------------------------------------------------------------------------------
tVoid
dia_SrvHandler_ReadAmplifierConnectionStatus::vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ )
{
	dia_tclFnctTrace oTrace("dia_SrvHandler_ReadAmplifierConnectionStatus::vProcessRequest()");
	tU8 u8ConnetionStatus = DIA_C_U8_STATUS_NOT_CONNECTED;
	FILE* pFile = fopen (File_Path.c_str(),"r" );
	char Buffer[1]; //To store 1 byte connection status value
	if(pFile != NULL)
	{
		DIA_TR_INF("OABR Connection Status file is: %s:", File_Path.c_str());
		size_t usedSize = fread(Buffer,sizeof(Buffer),1,pFile); //  read from file
		if(usedSize > 0)
		{
			DIA_TR_INF("dia_SrvHandler_ReadAmplifierConnectionStatus::value of connection status: 0x%02x",Buffer[0]);
			if((Buffer[0]) == 0x31)
			{
				u8ConnetionStatus = DIA_C_U8_STATUS_CONNECTED;
				DIA_TR_INF("dia_SrvHandler_ReadAmplifierConnectionStatus::Connection Status is Connected");
			}
			else{
				DIA_TR_INF("dia_SrvHandler_ReadAmplifierConnectionStatus::Connection Status is Not Connected");
			}
		}
		else
		{
			DIA_TR_ERR("!!! readFileToBuffer => no Data");
		}
		fclose (pFile);
	}
	else
	{
		DIA_TR_ERR("!!! readFileToBuffer => fopen FAILED");
	}
	oDiagMsgBuffer().vSetPosResp();
	oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) u8ConnetionStatus));
	vResReadyAndQuit();
}





