/************************************************************************
* FILE:           dia_SrvHandler_MercedesTruckSoftware.cpp
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    This file contains the definition of dia_SrvHandler_MercedesTruckSoftware class,
*				  that provides a service handler which can be used to process  
*                 diagnostic READ requests for  Software Part Number.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 09.04.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __DIA_SRV_HANDLER_MERCEDES_TRUCK_SOFTWARE_H__
#include "project/services/customer/dia_SrvHandler_MercedesTruckSoftware.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#include <sstream>
#include <common/framework/xml/tinyxml2.h>

using namespace tinyxml2;

namespace dia {

#define DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))
#define DIA_U16_MERCEDES_TRUCK_SOFTWARE_DATA_LENGTH  ((tU16) (13))                                             

static const std::string targetXMLpath  ("/var/opt/bosch/persistent/avdecc/cisinstallation/CIS_network.xml");
static const std::string targetNodeName ("ASachnummer");
static const std::string defaultMercedesTruckSoftwarePartNumber ("0000000000000");

//------------------------------------------------------------------------------

dia_SrvHandler_MercedesTruckSoftware::dia_SrvHandler_MercedesTruckSoftware ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name, sid, did),
     _MercedesTruckSoftwarePartNumber(defaultMercedesTruckSoftwarePartNumber),
     _MercedesTruckSoftwarePartNumberFound(FALSE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_MercedesTruckSoftware::dia_SrvHandler_MercedesTruckSoftware(tCString,tU8,tU16)");
}

//------------------------------------------------------------------------------

dia_SrvHandler_MercedesTruckSoftware::~dia_SrvHandler_MercedesTruckSoftware ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandler_MercedesTruckSoftware::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_MercedesTruckSoftware::vProcessRequest(...)");

   _MercedesTruckSoftwarePartNumber = defaultMercedesTruckSoftwarePartNumber;
   _MercedesTruckSoftwarePartNumberFound = FALSE;
      
    parseXML(targetXMLpath);
   
    std::vector<tU8> vcMercedesTruckSoftwarePartNumber(_MercedesTruckSoftwarePartNumber.begin(), _MercedesTruckSoftwarePartNumber.end());

    // Sending back the positive answer
    oDiagMsgBuffer().vSetPosResp();
    oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH + DIA_U16_MERCEDES_TRUCK_SOFTWARE_DATA_LENGTH));

    for(tU8 i = 0; i < DIA_U16_MERCEDES_TRUCK_SOFTWARE_DATA_LENGTH; i++)
    {
      (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH+i), vcMercedesTruckSoftwarePartNumber[i]);
    }

    vResReadyAndQuit();
}
/**
*
* \brief      method called to parse xml
*
*             This method is used to parse the xml file.
*             
* \param[in]  file      xml file path
*
* \return     none
*/
void
dia_SrvHandler_MercedesTruckSoftware::parseXML ( const std::string& file )
{
   ScopeTrace oTrace("dia::dia_SrvHandler_MercedesTruckSoftware::parseXML(...)");
   
   XMLDocument xmlDoc;
   XMLError retCode = xmlDoc.LoadFile(file.c_str());

   if(XML_SUCCESS == retCode)
   {
   		size_t found = file.find_last_of("/\\");
      	std::string FileName = file.substr(found+1);
      	std::string FilePath = file.substr(0,found);

      	DIA_TR_INF("+------------------------------+");
      	DIA_TR_INF("| START PARSING OF XML CONTENT |");
      	DIA_TR_INF("+------------------------------+");
      	DIA_TR_INF("");
      	DIA_TR_INF("+ PATH: \"%s\"",FilePath.c_str());
      	DIA_TR_INF("+ FILE: \"%s\"",FileName.c_str());

      	XMLElement* root = xmlDoc.RootElement();
	
		for( XMLNode* node = root->FirstChild(); node; node = node->NextSibling() )
		{
            if(!_MercedesTruckSoftwarePartNumberFound)
            {
			     std::string Name = node->Value();
			     DIA_TR_INF("dia_SrvHandler_MercedesTruckSoftware:  Node Name: \"%s\"", Name.c_str());
			     recursiveParse(node);  	
            }
		}
   }

}
/**
*
* \brief      recursive method called to parse the node
*
*             This method is used to parse the xml node and search the desired target value. 
*             Once the target is available, the value is extraced and stored in member variable.
*             
* \param[in]  node      xml node pointer
*
* \return     none
*/
void 
dia_SrvHandler_MercedesTruckSoftware::recursiveParse(XMLNode* node)
{
    // putting below trace makes my trace ugly & un-readable as this is a recursive function :(
    // it simply floods the trace
	//ScopeTrace oTrace("dia::dia_SrvHandler_MercedesTruckSoftware::recursiveElementParse(...)");	
	
	if(node)
	{
		XMLElement* MercedesTruckElement = node->ToElement();
		if(MercedesTruckElement)
		{
			std::string MercedesTruckElementName = MercedesTruckElement->Value();

			if(targetNodeName == MercedesTruckElementName)
			{
				if(MercedesTruckElement->GetText() != NULL)
				{
					_MercedesTruckSoftwarePartNumber = MercedesTruckElement->GetText();
					_MercedesTruckSoftwarePartNumberFound = TRUE;
					DIA_TR_INF("dia_SrvHandler_MercedesTruckSoftware:  Element Name: \"%s\"",MercedesTruckElementName.c_str());
					DIA_TR_INF("dia_SrvHandler_MercedesTruckSoftware: Software Part Number : \"%s\"",_MercedesTruckSoftwarePartNumber.c_str());
					return;
				}
				else
				{
					DIA_TR_INF("dia_SrvHandler_MercedesTruckSoftware:  Element Name: ASachnummer=Not found"	);
					return;
				}
			}
		}

		XMLNode* n = node->FirstChild();
		if(!n)
		{
			XMLElement* e = node->ToElement();
								
			if(e)
			{
				std::string eName = e->Value();
				DIA_TR_INF("dia_SrvHandler_MercedesTruckSoftware:  Element Name: \"%s\"",eName.c_str());
			}
		}
		else
		{
			std::string nName = node->Value();
			DIA_TR_INF("dia_SrvHandler_MercedesTruckSoftware:  Node Name: \"%s\"", nName.c_str());
		
			while(n)
			{
				recursiveParse(n);

                if(!_MercedesTruckSoftwarePartNumberFound)
                {
				    n  = n->NextSibling();
                }
                else
                {
                    break;
                }
			}
			
		}
	}
} /* dia_SrvHandler_MercedesTruckSoftware::recursiveElementParse(XMLNode* node) */

} /* namespace dia */
