/*
 * dia_SrvHandler_KeyPressSWS.cpp
 *
 *  Created on: 05.10.2015
 *      Author: stc2hi
 * 	--------------------------------------------------------------------------------------------------------------------------------------------
 * 	Date 	        Author	           Modification
 * 	1.9.16			dvd5kor			   AIVI-26191 - Changed the mapping according to new Spec
 */
// TTFis:\> DIA_REQ UDS 03 22 03 02

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_SRVHANDLER_KEY_PRESS_SWS_H_
#include "dia_SrvHandler_KeyPressSWS.h"
#endif


#define DATA_START 3
#define DATA_LENGTH 1


//-----------------------------------------------------------------------------

dia_SrvHandler_KeyPressSWS::dia_SrvHandler_KeyPressSWS ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_KeyPressSWS",
	  DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
	  (tU16) DIA_C_U16_DID_AIVI_KEY_PRESS_SWS /*DID*/,
     // Because of the many involved components a longer service handler timeout is needed.
     3*DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS)
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressSWS::dia_SrvHandler_KeyPressSWS(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_KeyPressSWS::~dia_SrvHandler_KeyPressSWS ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_KeyPressSWS::~dia_SrvHandler_KeyPressSWS !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressSWS::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressSWS::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandlingPrj* pInterface = 0;
   if ( querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS )
   {
   	  DIA_TR_INF("dia_SrvHandler_KeyPressSWS::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
      	(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
         if ( pInterface->getPressedKeys () == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
		 else
		 {
         	DIA_TR_INF("dia_SrvHandler_KeyPressSWS::vProcessRequest - getPressedKeys() failed.");
         }
      }
   }
   else
   {
   	  DIA_TR_INF("dia_SrvHandler_KeyPressSWS::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
      DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressSWS::vOnGetPressedKey ( const std::vector<dia_tPressedKeyPrj> pressedKeys )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressSWS:vOnGetPressedKey");

   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU8 u8KeyBitmap[DATA_LENGTH] = {0};

   for (tU32 i = 0; i < pressedKeys.size(); i++)
   {
      dia_eVdInuptHandlingKeyCodePrj pressedKey = pressedKeys[i].mCode;

      if (!((pressedKeys[i].mStatus == 1) || (pressedKeys[i].mStatus == 2)))
      {
         DIA_TR_ERR(" ---  UNKNOWN STATUS (%d) for KEY (%d)!!!!", pressedKeys[i].mStatus, pressedKey);
         continue;
      }

      switch (pressedKey)
      {
         case DIA_PRJ_SWC_KEY_CODE_UP:           u8KeyBitmap[0] |= (tU8) (1U << 0); break;
         case DIA_PRJ_SWC_KEY_CODE_DOWN:  	      u8KeyBitmap[0] |= (tU8) (1U << 1); break;
         case DIA_PRJ_SWC_KEY_CODE_VOL_UP:       u8KeyBitmap[0] |= (tU8) (1U << 2); break;
         case DIA_PRJ_SWC_KEY_CODE_VOL_DOWN:     u8KeyBitmap[0] |= (tU8) (1U << 3); break;
         case DIA_PRJ_SWC_KEY_CODE_TEL_HANG_UP:  u8KeyBitmap[0] |= (tU8) (1U << 4); break;
         case DIA_PRJ_SWC_KEY_CODE_TEL_VR:       u8KeyBitmap[0] |= (tU8) (1U << 5); break;
         case DIA_PRJ_SWC_KEY_CODE_OK:           u8KeyBitmap[0] |= (tU8) (1U << 6); break;
         case DIA_PRJ_SWC_KEY_CODE_BACK:
         case DIA_PRJ_SWC_KEY_CODE_SEEK_UP:
         case DIA_PRJ_SWC_KEY_CODE_SEEK_DOWN:	 break;
         default: break;
      }
   }

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START, u8KeyBitmap[0]);

   vResReadyAndQuit();
}
