/*
 * dia_SrvHandler_KeyPressCDDrive.cpp
 *
 *  Created on: Sep 18, 2017
 *      Author: mky6kor
 */

// TTFis:\> DIA_REQ UDS 03 22 03 05

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_SRVHANDLER_KEY_PRESS_CD_DRIVE_H_
#include "dia_SrvHandler_KeyPressCDDrive.h"
#endif


#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_KeyPressCDDrive::dia_SrvHandler_KeyPressCDDrive ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_KeyPressCDDrive",
	  DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
	  (tU16) DIA_C_U16_DID_AIVI_KEY_PRESS_CD_DRIVE_EJECT /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressCDDrive::dia_SrvHandler_KeyPressCDDrive(void)");
}

dia_SrvHandler_KeyPressCDDrive::~dia_SrvHandler_KeyPressCDDrive ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_KeyPressCDDrive::~dia_SrvHandler_KeyPressCDDrive !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressCDDrive::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressCDDrive::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandlingPrj* pInterface = 0;
   if ( querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS )
   {
   	DIA_TR_INF("dia_SrvHandler_KeyPressCDDrive::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
      	(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
         if ( pInterface->getPressedKeys () == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
		   else
		   {
         	DIA_TR_INF("dia_SrvHandler_KeyPressCDDrive::vProcessRequest - getPressedKeys() failed.");
         }
      }
   }
   else
   {
   	  DIA_TR_INF("dia_SrvHandler_KeyPressCDDrive::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
      DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}


//-----------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressCDDrive::vOnGetPressedKey ( const std::vector<dia_tPressedKeyPrj> pressedKeys )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressCDDrive:vOnGetPressedKey");

   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU8 u8KeyBitmap[DATA_LENGTH] = {0};

  std::vector<dia_tPressedKeyPrj>::const_iterator pressedKeyVec=pressedKeys.begin();

  for(; pressedKeyVec!=pressedKeys.end(); ++pressedKeyVec)
   {
	 dia_tPressedKeyPrj keyCode=(*pressedKeyVec);
	 if(keyCode.mCode==DIA_PRJ_KEY_CODE_EJECT)
      {
	    u8KeyBitmap[0] |= (tU8) (1U << 6);
	    DIA_TR_INF("dia_SrvHandler_KeyPressCDDrive::vOnGetPressedKey keycode matches");
      }
	 else
      {
	    DIA_TR_INF("dia_SrvHandler_KeyPressCDDrive::vOnGetPressedKey keycode does not match");
      }
   }

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START, u8KeyBitmap[0]);

   vResReadyAndQuit();
}
