/*
 * dia_SrvHandler_InputLines.h
 *
 *  Created on: 24.09.2015
 *      Author: shw2abt
 */
//TTFis: DIA_REQ UDS 04 22 01 01
#ifndef DIA_SRVHANDLER_INPUT_LINES_H_
#define DIA_SRVHANDLER_INPUT_LINES_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUX_LISTENER__
#include "common/interfaces/dia_IAuxListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_PARKINGBRAKE_LISTENER__
#include "common/interfaces/dia_IParkingBrakeListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REVERSEGEAR_LISTENER__
#include "common/interfaces/dia_IReverseGearListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#include "common/interfaces/dia_IDimmingListener.h"
#endif



class dia_SrvHandler_InputLines
   : public dia_ServiceHandlerUDS,
     public dia_IAuxListenerImpl,
     public dia_ISpmListenerImpl,
     public dia_IParkingBrakeListenerImpl,
     public dia_IReverseGearListenerImpl,
     public dia_IDimmingListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_InputLines);

public:
   //! class constructor
   dia_SrvHandler_InputLines ( void );
   //! function receives request from tester. data is analyzed and prepared for diagnosis-internal communication
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

   //! receive response from component and store value into member variable
   virtual void vOnConnectionState ( dia_eAuxConnectionState state );
   //! receive response from component and store value into member variable
   virtual void vOnPowerState ( dia_eSpmSystemPowerState pwrState );
   //! response with current active dimming mode
   virtual void vOnDimmingMode ( dia_eDimmingStatus dimmStatus );
   //! response to getReverseGearStatus
   virtual void vOnReverseGearStatus ( dia_eReverseGearStatus status );
   //! response to getParkingBrakeStatus
   virtual void vOnParkingBrakeStatus ( dia_eParkingBrakeState status );
   //! response with current pwm dimming rate
   virtual void vOnDimmingPWM ( tU16 pwmRate );
   //! response with current active illumination status
   virtual void vOnDimmingIllStatus ( dia_eDimmingStatus dimmStatus );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_InputLines(void);
   //! overwrite super class function to clear local member variables
   void vOnTimeout ( void );
   //! checks if all component responses are available and sends merged response to tester
   void checkDataCompleteAndSend();

   // Member variables to collect component responses
   dia_eAuxConnectionState m_ConnectionState;
   dia_eSpmSystemPowerState m_PowerState;
   dia_eDimmingStatus m_DimmingState;
   tU16 m_DimmingPwm;
   dia_eReverseGearStatus m_ReverseGearState;
   dia_eParkingBrakeState m_ParkingBrakeSate;
   dia_eDimmingStatus m_DimmingIllState;
};


#endif /* DIA_SRVHANDLER_INPUT_LINES_H_ */
