/*
 * dia_SrvHandler_InputLines.cpp
 *
 *  Created on: 24.09.2015
 *      Author: shw2abt
 *      -----------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      05.04.2016  bsu9kor		NCG3D-6659
 *
 *      -----------------------------------------------------------------------------------------------------------------------
 */
// TTFis: DIA_REQ UDS 04 22 01 01
#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef DIA_SRVHANDLER_INPUT_LINES_H_
#include "project/services/customer/dia_SrvHandler_InputLines.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_InputLines::dia_SrvHandler_InputLines(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_InputLines", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_INPUT_LINES,
            // Because of the many involved components a longer service handler timeout is needed.
            3*DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS),
      m_ConnectionState(DIA_EN_AUX_CONNECTION_UNKNOWN),
      m_PowerState(DIA_EN_SYS_PWR_STATE_UNKNOWN),
      m_DimmingState(DIA_EN_DIMMING_STATUS_UNKNOWN),
      m_DimmingPwm(0xFFFF),
      m_ReverseGearState(DIA_EN_REVERSE_GEAR_UNKNOWN),
      m_ParkingBrakeSate(DIA_EN_PARKING_BRAKE_UNKNOWN),
      m_DimmingIllState(DIA_EN_DIMMING_STATUS_UNKNOWN)
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::dia_SrvHandler_InputLines(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_InputLines::~dia_SrvHandler_InputLines(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAuxListener>(this);
      (void) unsetSysAdapterListener<dia_IParkingBrakeListener>(this);
      (void) unsetSysAdapterListener<dia_IReverseGearListener>(this);
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      (void) unsetSysAdapterListener<dia_IDimmingListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_InputLines::~dia_SrvHandler_InputLines !!!");
      DIA_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vProcessRequest(const std::vector<void*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vProcessRequest");
   tBool errorDetected = TRUE;

   checkDataCompleteAndSend();

   dia_IAux* pAux = 0;
   if (querySysAdapterInterface<dia_IAux>(&pAux) == DIA_SUCCESS) {
      if (pAux) {
         (void) setSysAdapterListener<dia_IAuxListener>(this);
         if (pAux->auxConnectionStatus_Get() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_SrvHandler_InputLines::vProcessRequest auxConnectionStatus_Get with ERRORS!");
         }
      }
   }

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getSystemPowerMode() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_SrvHandler_InputLines::vProcessRequest getSystemPowerMode with ERRORS!");
         }
      }
   }

   dia_IParkingBrake* pPKB = 0;
   if (querySysAdapterInterface<dia_IParkingBrake>(&pPKB) == DIA_SUCCESS) {
      if (pPKB) {
         (void) setSysAdapterListener<dia_IParkingBrakeListener>(this);
         if (pPKB->getParkingBrakeStatus() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_SrvHandler_InputLines::vProcessRequest getParkingBrakeStatus with ERRORS!");
         }
      }
   }

   dia_IReverseGear* pRVG = 0;
   if (querySysAdapterInterface<dia_IReverseGear>(&pRVG) == DIA_SUCCESS) {
      if (pRVG) {
         (void) setSysAdapterListener<dia_IReverseGearListener>(this);
         if (pRVG->getReverseGearStatus() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_SrvHandler_InputLines::vProcessRequest getReverseGearStatus with ERRORS!");
         }
      }
   }

   dia_IDimming* pDim = 0;
   if (querySysAdapterInterface<dia_IDimming>(&pDim) == DIA_SUCCESS) {
      if (pDim) {
         (void) setSysAdapterListener<dia_IDimmingListener>(this);
         /* request MR Out (Day ON/OFF) */
         if (pDim->getDisplIlluminationMode() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_SrvHandler_InputLines::vProcessRequest getDisplIlluminationMode with ERRORS!");
         }
         /* Dimming PWM */
         /* Dimming ILL Control */
         if (pDim->getIlluminationStatus() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_SrvHandler_InputLines::vProcessRequest getIlluminationStatus with ERRORS!");
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_IAuxListener>(this);
      (void) unsetSysAdapterListener<dia_IParkingBrakeListener>(this);
      (void) unsetSysAdapterListener<dia_IReverseGearListener>(this);
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      (void) unsetSysAdapterListener<dia_IDimmingListener>(this);
      DIA_TR_ERR("dia_SrvHandler_InputLines --- FAILURE IN ANY SA FEATURE REQUEST!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnConnectionState ( dia_eAuxConnectionState state )     // Data from fc_AUX
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnConnectionState");

   if(state!=DIA_EN_AUX_CONNECTION_UNKNOWN && state<DIA_EN_AUX_CONNECTION_COUNT){
      m_ConnectionState = state;
   } else {
      DIA_TR_ERR("dia_SrvHandler_InputLines::vOnConnectionState Connection state 0x%02x UNKNOWN or >COUNT !", state);
   }
   checkDataCompleteAndSend();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnPowerState ( dia_eSpmSystemPowerState pwrState )      // Data from LCM aka SPM
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnPowerState");

   if(pwrState!=DIA_EN_SYS_PWR_STATE_UNKNOWN && pwrState<DIA_EN_SYS_PWR_STATE_COUNT){
      m_PowerState = pwrState;
   } else {
      DIA_TR_ERR("dia_SrvHandler_InputLines::vOnPowerState Power state 0x%02x UNKNOWN or >COUNT !", pwrState);
   }
   checkDataCompleteAndSend();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnDimmingMode ( dia_eDimmingStatus dimmStatus )         // Data from vd_Dimming
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnDimmingMode");

   if(dimmStatus!=DIA_EN_DIMMING_STATUS_UNKNOWN && dimmStatus<DIA_EN_DIMMING_STATUS_COUNT){
      m_DimmingState = dimmStatus;
   } else {
      DIA_TR_ERR("dia_SrvHandler_InputLines::vOnDimmingMode Dimming state 0x%02x UNKNOWN or >COUNT !", dimmStatus);
   }
   checkDataCompleteAndSend();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnReverseGearStatus ( dia_eReverseGearStatus status )   // Data from vd_VehicleData
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnReverseGearStatus");

   if(status!=DIA_EN_REVERSE_GEAR_UNKNOWN && status<DIA_EN_REVERSE_GEAR_COUNT){
      m_ReverseGearState = status;
   } else {
      DIA_TR_ERR("dia_SrvHandler_InputLines::vOnReverseGearStatus Reverse Gear state 0x%02x UNKNOWN or >COUNT !", status);
   }
   checkDataCompleteAndSend();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnParkingBrakeStatus ( dia_eParkingBrakeState status )  // Data from vd_VehicleData
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnParkingBrakeStatus");

   if(status!=DIA_EN_PARKING_BRAKE_UNKNOWN && status<DIA_EN_PARKING_BRAKE_COUNT){
      m_ParkingBrakeSate = status;
   } else {
	   if(status == DIA_EN_PARKING_BRAKE_UNKNOWN){
		   DIA_TR_ERR("dia_SrvHandler_InputLines::vOnParkingBrakeStatus Parking Brake state 0x%02x UNKNOWN !", status);
		   m_ParkingBrakeSate = DIA_EN_PARKING_BRAKE_OFF;
	   }
	   else{
			DIA_TR_ERR("dia_SrvHandler_InputLines::vOnParkingBrakeStatus Parking Brake state 0x%02x  >COUNT !", status);
	   }
   }
   checkDataCompleteAndSend();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnDimmingPWM ( tU16 pwmRate )  // Data from vd_Dimming
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnDimmingPWM");

   if ((pwmRate <= 1000) // max value 100.0 %
         || (pwmRate == 0x3ff)) // Invalid or Unavailable
   {
      m_DimmingPwm = pwmRate;
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_InputLines::vOnParkingBrakeStatus pwm rate to high 0x%02x / %d !", pwmRate, pwmRate);
   }

   checkDataCompleteAndSend();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnDimmingIllStatus ( dia_eDimmingStatus dimmStatus )         // Data from vd_Dimming
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnDimmingIllStatus");

   if(dimmStatus!=DIA_EN_DIMMING_STATUS_UNKNOWN && dimmStatus<DIA_EN_DIMMING_STATUS_COUNT){
      m_DimmingIllState = dimmStatus;
   } else {
      DIA_TR_ERR("dia_SrvHandler_InputLines::vOnDimmingIllStatus Dimming Ill 0x%02x UNKNOWN or >COUNT !", dimmStatus);
   }
   checkDataCompleteAndSend();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::checkDataCompleteAndSend(){
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::checkDataCompleteAndSend");

//   if (m_ConnectionState != DIA_EN_AUX_CONNECTION_UNKNOWN && m_ConnectionState < DIA_EN_AUX_CONNECTION_COUNT) {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_ConnectionState ready 0x%02x .", m_ConnectionState);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_ConnectionState NOT ready 0x%02x .", m_ConnectionState);
//   }
//   if (m_PowerState != DIA_EN_SYS_PWR_STATE_UNKNOWN && m_PowerState < DIA_EN_SYS_PWR_STATE_COUNT) {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_PowerState ready 0x%02x .", m_PowerState);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_PowerState NOT ready 0x%02x .", m_PowerState);
//   }
//   if (m_DimmingState != DIA_EN_DIMMING_STATUS_UNKNOWN && m_DimmingState < DIA_EN_DIMMING_STATUS_COUNT) {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_DimmingState ready 0x%02x .", m_DimmingState);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_DimmingState NOT ready 0x%02x .", m_DimmingState);
//   }
//   if (m_DimmingPwm <= 1000) {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_DimmingPwm ready 0x%d .", m_DimmingPwm);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_DimmingPwm NOT ready 0x%d .", m_DimmingPwm);
//   }
//   if (m_DimmingIllState != DIA_EN_DIMMING_STATUS_UNKNOWN && m_DimmingIllState < DIA_EN_DIMMING_STATUS_COUNT) {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_DimmingIllState ready 0x%02x .", m_DimmingIllState);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_DimmingIllState NOT ready 0x%02x .", m_DimmingIllState);
//   }
//   if (m_ReverseGearState != DIA_EN_REVERSE_GEAR_UNKNOWN && m_ReverseGearState < DIA_EN_REVERSE_GEAR_COUNT) {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_ReverseGearState ready 0x%02x .", m_ReverseGearState);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_ReverseGearState NOT ready 0x%02x .", m_ReverseGearState);
//   }
//   if (m_ParkingBrakeSate != DIA_EN_PARKING_BRAKE_UNKNOWN && m_ParkingBrakeSate < DIA_EN_PARKING_BRAKE_COUNT) {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_ParkingBrakeSate ready 0x%02x .", m_ParkingBrakeSate);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend m_ParkingBrakeSate NOT ready 0x%02x .", m_ParkingBrakeSate);
//   }

   /*===================*/
   /* Data verification */
   /*===================*/
   if(m_ConnectionState!=DIA_EN_AUX_CONNECTION_UNKNOWN && m_ConnectionState<DIA_EN_AUX_CONNECTION_COUNT
         && m_PowerState!=DIA_EN_SYS_PWR_STATE_UNKNOWN && m_PowerState<DIA_EN_SYS_PWR_STATE_COUNT
         && m_DimmingState!=DIA_EN_DIMMING_STATUS_UNKNOWN && m_DimmingState<DIA_EN_DIMMING_STATUS_COUNT
         && ((m_DimmingPwm <= 1000) || (m_DimmingPwm == 0x3ff))
         && m_DimmingIllState!=DIA_EN_DIMMING_STATUS_UNKNOWN && m_DimmingIllState<DIA_EN_DIMMING_STATUS_COUNT
         && m_ReverseGearState!=DIA_EN_REVERSE_GEAR_UNKNOWN && m_ReverseGearState<DIA_EN_REVERSE_GEAR_COUNT
         && m_ParkingBrakeSate!=DIA_EN_PARKING_BRAKE_UNKNOWN && m_ParkingBrakeSate<DIA_EN_PARKING_BRAKE_COUNT)
   {
//      tBool errorDetected = FALSE;
      tU8 byte1 = 0x00;
      tU8 byte2 = 0x00;

      /*===================================*/
      /* Data combination to output format */
      /*===================================*/
      // Byte 2 - Bit 0 IGN
      if(m_PowerState==DIA_EN_SYS_PWR_STATE_RUN){  // RUN == Ignition+ACC ON
         byte2 = byte2|0x01;
      }
  
	  // Byte 2 - Bit 1-7 Illumination Con (0 to 100%)
      if (m_DimmingPwm == 0x3ff) //Invalid input
      {
         tU8 IllumVal = 0x7F; //Invalid output
         byte2 = byte2|((tU8)(IllumVal << 1));
      }
      else if(m_DimmingPwm>0){
		 tU8 IllumVal = (tU8) (m_DimmingPwm / 10U); 
         byte2 = byte2|((tU8)(IllumVal << 1));
      }

      // Byte 1 - Bit 0 MR out
      if(m_DimmingState==DIA_EN_DIMMING_STATUS_ON){
         byte1 = byte1|0x01;
      }

      // Byte 1 - Bit 1 Illumination
      if(m_DimmingIllState==DIA_EN_DIMMING_STATUS_ON){
         byte1 = byte1|0x02;
      }

      // Byte 1 - Bit 2 REV
      if(m_ReverseGearState==DIA_EN_REVERSE_GEAR_ON){
         byte1 = byte1|0x04;
      }

      // Byte 1 - Bit 3 Mute from TCU
      // Part of scope 2; NA in scope 1

      // Byte 1 - Bit 4 PKB
      if(m_ParkingBrakeSate==DIA_EN_PARKING_BRAKE_ON){
         byte1 = byte1|0x10;
      }

      // Byte 1 - Bit 5 Info_AUX_IN
      if(m_ConnectionState==DIA_EN_AUX_CONNECTION_ON){
         byte1 = byte1|0x20;
      }

      // Byte 1 - Bit 6 ACC
      if(m_PowerState==DIA_EN_SYS_PWR_STATE_RUN || m_PowerState==DIA_EN_SYS_PWR_STATE_ACCESSORY){  // RUN == Ignition+ACC ON
         byte1 = byte1|0x40;
      }

      // Byte 1 - Bit 7 Auto ACC
      // Info Kollai Klaus-Peter (CM-AI/EPB2): ACC and Auto ACC are identical. Both would never appear at the same time in one target
      // For A-IVI we take ACC and Auto ACC is not set

      /*===============*/
      /* Send response */
      /*===============*/
      (void) unsetSysAdapterListener<dia_IAuxListener>(this);
      (void) unsetSysAdapterListener<dia_IParkingBrakeListener>(this);
      (void) unsetSysAdapterListener<dia_IReverseGearListener>(this);
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      (void) unsetSysAdapterListener<dia_IDimmingListener>(this);

//      if (!errorDetected) {
      //if we have received the responses from all components we can answer to the tester
      // Sending back positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, byte2);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, byte1);

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend SUCCESSFUL.");

//      } else {
//         // Sending back negative answer
//         oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
//         vResReadyAndQuit();
//         DIA_TR_ERR("dia_SrvHandler_InputLines::checkDataCompleteAndSend FAILED!");
//      }

      // Clean data after completion for next run
      m_ConnectionState = DIA_EN_AUX_CONNECTION_UNKNOWN;
      m_PowerState = DIA_EN_SYS_PWR_STATE_UNKNOWN;
      m_DimmingState = DIA_EN_DIMMING_STATUS_UNKNOWN;
      m_DimmingPwm = 0xFFFF;
      m_DimmingIllState = DIA_EN_DIMMING_STATUS_UNKNOWN;
      m_ReverseGearState = DIA_EN_REVERSE_GEAR_UNKNOWN;
      m_ParkingBrakeSate = DIA_EN_PARKING_BRAKE_UNKNOWN;

   } else {
      DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend some information are missing; waiting for ...");

      if(!(m_ConnectionState!=DIA_EN_AUX_CONNECTION_UNKNOWN && m_ConnectionState<DIA_EN_AUX_CONNECTION_COUNT)){
         DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend ... AUX.");
      }
      if(!(m_PowerState!=DIA_EN_SYS_PWR_STATE_UNKNOWN && m_PowerState<DIA_EN_SYS_PWR_STATE_COUNT)){
         DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend ... POWER STATE.");
      }
      if(!(m_DimmingState!=DIA_EN_DIMMING_STATUS_UNKNOWN && m_DimmingState<DIA_EN_DIMMING_STATUS_COUNT)){
         DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend ... DIMMING.");
      }
      if(!(m_DimmingPwm <= 1000) && (m_DimmingPwm != 0x3ff)){
         DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend ... DIMMING PWM.");
      }
      if(!(m_DimmingIllState!=DIA_EN_DIMMING_STATUS_UNKNOWN && m_DimmingIllState<DIA_EN_DIMMING_STATUS_COUNT)){
         DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend ... DIMMING ILL Status.");
      }
      if(!(m_ReverseGearState!=DIA_EN_REVERSE_GEAR_UNKNOWN && m_ReverseGearState<DIA_EN_REVERSE_GEAR_COUNT)){
         DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend ... REVERSE.");
      }
      if(!(m_ParkingBrakeSate!=DIA_EN_PARKING_BRAKE_UNKNOWN && m_ParkingBrakeSate<DIA_EN_PARKING_BRAKE_COUNT)){
         DIA_TR_INF("dia_SrvHandler_InputLines::checkDataCompleteAndSend ... PARKING BRAKE.");
      }

   }
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputLines::vOnTimeout ( void ){
   dia_tclFnctTrace trc("dia_SrvHandler_InputLines::vOnTimeout");

   // Clean data after completion for next run
   m_ConnectionState = DIA_EN_AUX_CONNECTION_UNKNOWN;
   m_PowerState = DIA_EN_SYS_PWR_STATE_UNKNOWN;
   m_DimmingState = DIA_EN_DIMMING_STATUS_UNKNOWN;
   m_DimmingPwm = 0xFFFF;
   m_DimmingIllState = DIA_EN_DIMMING_STATUS_UNKNOWN;
   m_ReverseGearState = DIA_EN_REVERSE_GEAR_UNKNOWN;
   m_ParkingBrakeSate = DIA_EN_PARKING_BRAKE_UNKNOWN;

   dia_ServiceHandlerUDS::vOnTimeout();
}
