/*
 * dia_SrvHandler_GPSReceptionLevel.h
 *
 *  Created on: 02.09.2016
 *      Author: bma9kor
 */

#ifndef DIA_SRVHANDLER_GPSRECEPTIONLEVEL_H_
#define DIA_SRVHANDLER_GPSRECEPTIONLEVEL_H_

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif


class dia_SrvHandler_GPSReceptionLevel
   : public dia_ServiceHandlerUDS,
     public dia_IGNSSListenerImpl
{
   	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_GPSReceptionLevel);


    tU8 m_u8GPSReceptionLevel;
public:
   //! class constructor
   	dia_SrvHandler_GPSReceptionLevel();

	/**
	  * \brief    	handle the received request
	  *
	  *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
	  *				The SystemAdapter returns the current of the GNSS antenna.
	  *
	  * \param[in]	tVoid*     -
	  * \param[in]	tVoid*     -
	  */
	virtual tVoid vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ );

	/**
	  * \brief    	status for the requested the current of the GNSS antenna
	  *
	  *				Function receives the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the expected value to the tester.
	  *
	  * \param[in]	midw_ext_fi_tclString btDeviceAddr	BT Device Name String
	  * \param[in]	tU32 btDeviceAddr_size length of btDeviceAddr
	  */
	virtual tVoid vOnGPSReceptionLevel ( const dia_tGPSReceptionLevel& info);


protected:
	//! class destructor
	virtual ~dia_SrvHandler_GPSReceptionLevel();

};


#endif /* DIA_SRVHANDLER_GPSRECEPTIONLEVEL_H_ */
