/*
 * dia_SrvHandler_ECUTemperatureRead.h
 *
 *  Created on: 06.09.2016
 *      Author: dvd5kor
 * 
 *TTFis:\> DIA_REQ UDS 03 22 10 07
 *
 * -----------------------------------------------------------------------------------
 * Date 			| Author			 | Modification                               |
 * 06.09.16    		| dvd5kor	  		 | ECU Temperature Read                    |
 * ------------------------------------------------------------------------------------
 */

#ifndef DIA_SRVHANDLER_ECUTEMPERATUREREAD_H_
#define DIA_SRVHANDLER_ECUTEMPERATUREREAD_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HEATCONTROL_LISTENER__
#include "common/interfaces/dia_IHeatControlListener.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

class dia_SrvHandler_ECUTemperatureRead
   : public dia_ServiceHandlerUDS,
     public dia_IHeatControlListenerImpl
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ECUTemperatureRead);

public:
	//! class constructor
	dia_SrvHandler_ECUTemperatureRead ( void );
	//! class constructor
	dia_SrvHandler_ECUTemperatureRead ( tCString name, tU8 sid, tU16 did , tU8 temperatureID );

   //! class destructor
   virtual ~dia_SrvHandler_ECUTemperatureRead ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ );

   //! a timeout has occurred
   virtual void vOnTimeout ( void );

   //! receives the current ECU Temperature value
   virtual void vOnTemperatureInfo ( std::list<dia_tHeatCtrlTemperature>& tempList );
   
protected:
	//local function to get the temperature class
	dia_eHeatCtrlTemperatureClass getTemperatureClass ( void ) const;

	tU8 mTemperatureID;

};

#endif /*dia_SrvHandler_ECUTemperatureRead_H_ */



