/*
 * dia_SrvHandler_ECUSerialNumberDataIdentifier.cpp
 *
 *  Created on: 28.09.2015
 *      Author: wgl2hi
 */
// TTFis:\> DIA_REQ UDS 04 22 F1 8C

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif
#ifndef __DIA_SRVHANDLER_ECUSERIALNUMBERDATAIDENTIFIER_H__
#include "dia_SrvHandler_ECUSerialNumberDataIdentifier.h"
#endif

#define DATA_START  3
#define DATA_LENGTH 20

//-----------------------------------------------------------------------------

dia_SrvHandler_ECUSerialNumberDataIdentifier::dia_SrvHandler_ECUSerialNumberDataIdentifier ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_ECUSerialNumberDataIdentifier",
          DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
          (tU16)DIA_C_U16_DID_AIVI_ECU_SERIAL_NUMBER_IDENTIFIER )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ECUSerialNumberDataIdentifier::dia_SrvHandler_ECUSerialNumberDataIdentifier(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ECUSerialNumberDataIdentifier::~dia_SrvHandler_ECUSerialNumberDataIdentifier ( void )
{
    // no try/catch necessary
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ECUSerialNumberDataIdentifier::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ECUSerialNumberDataIdentifier::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IAIVISecurity* pInterface = OSAL_NULL;
   if ( (querySysAdapterInterface<dia_IAIVISecurity>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      (void) setSysAdapterListener<dia_IAIVISecurityListener>(this);

      if (pInterface->getEcuSerialNumber() == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
   }

   if (errorDetected == TRUE)
   {
      DIA_TR_ERR("!!! dia_SrvHandler_ECUSerialNumberDataIdentifier::vProcessRequest: FAILED to get EcuSerialNumber");

      (void) unsetSysAdapterListener<dia_IAIVISecurityListener>(this);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_ECUSerialNumberDataIdentifier::vOnEcuSerialNumber ( const std::vector<tU8>& serialno )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ECUSerialNumberDataIdentifier::vOnEcuSerialNumber");

   (void) unsetSysAdapterListener<dia_IAIVISecurityListener>(this);

   if (serialno.size() == DATA_LENGTH)
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      for (tU8 i = 0; i < DATA_LENGTH; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START + i, serialno[i] );
      }

      DIA_TR_INF("dia_SrvHandler_ECUSerialNumberDataIdentifier::vOnEcuSerialNumber SUCCESSFUL");

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_ERR("!!! FAILED to get EcuSerialNumber (%d) of correct size (%d)", serialno.size(), DATA_LENGTH);

      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
