/*!
 * \file       dia_SrvHandler_DataCarrierVersionRead.h
 *
 * \brief      Service handler that will read the dataCarrierVersion Value
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_DATACARRIERVERSION__
#define __INCLUDED_DIA_SRV_HANDLER_RDID_DATACARRIERVERSION__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATION_LISTENER__
#include "project/interfaces/dia_IHMINavigationListener.h"
#endif

class dia_SrvHandler_DataCarrierVersionRead
      : public dia_ServiceHandlerUDS,
      public dia_IHMINavigationListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandler_DataCarrierVersionRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_DataCarrierVersionRead);

public:
   //! class constructor
   dia_SrvHandler_DataCarrierVersionRead ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandler_DataCarrierVersionRead ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

   /**
   * \brief     subscribe for  Navigation Info
   *
   *        Function subscribes to the SystemAdapter for getting the HMI Navigation Info.
   *        The SystemAdapters return the actual values
   */
   tDiaResult subscribeForNavigationInfo();

   //! reply on getting value of DataSetVersion from NavigationService
   tVoid vOnDataSetVersionStatus(const std::string& dataSetVersion);

   //Error handling
   virtual void vOnTimeout ( void );

};

#endif /* __INCLUDED_DIA_SRV_HANDLER_RDID_DATACARRIERVERSION__ */