/*!
 * \file       dia_SrvHandler_DataCarrierVersionRead.cpp
 *
 * \brief      Service handler that will read the dataCarrierVersion Value
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_DATACARRIERVERSION__
#include "project/services/customer/dia_SrvHandler_DataCarrierVersionRead.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 9
//-----------------------------------------------------------------------------

dia_SrvHandler_DataCarrierVersionRead::dia_SrvHandler_DataCarrierVersionRead ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS("dia_SrvHandler_DataCarrierVersionRead",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_CENTER_CMC_19_DATA_CARRIER_VERSION)
{
   dia_tclFnctTrace trc("dia_SrvHandler_DataCarrierVersionRead::dia_SrvHandler_DataCarrierVersionRead");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_DataCarrierVersionRead::~dia_SrvHandler_DataCarrierVersionRead ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IHMINavigationListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_HMINavigationInfo::~dia_HMINavigationInfo !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
   
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_DataCarrierVersionRead::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_DataCarrierVersionRead::vProcessRequest");
  
   tBool errorDetected = TRUE;

   if (subscribeForNavigationInfo() != DIA_SUCCESS)
   {
      DIA_TR_ERR("dia_SrvHandler_DataCarrierVersionRead --- subscribeForNavigationInfo() FAILED!!!!");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_DataCarrierVersionRead --- subscribeForNavigationInfo() OK!!!!");
      errorDetected = FALSE;
   }

   if ( errorDetected )
   {
      DIA_TR_ERR("### dia_SrvHandler_DataCarrierVersionRead::vProcessRequest Error detected!");
      (void) unsetSysAdapterListener<dia_IHMINavigationListener>(this);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

}

//-----------------------------------------------------------------------------

tDiaResult dia_SrvHandler_DataCarrierVersionRead::subscribeForNavigationInfo()
{
   dia_tclFnctTrace trc("dia_SrvHandler_DataCarrierVersionRead::subscribeForNavigationInfo");

   DIA_TR_INF("dia_SrvHandler_DataCarrierVersionRead::subscribeForNavigationInfo()");

   dia_IHMINavigation* pInterface = 0;
   if (querySysAdapterInterface<dia_IHMINavigation>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_IHMINavigationListener>(this);

         if (pInterface->registerToDatasetVersion() == DIA_SUCCESS) {
            if (pInterface->getDatasetVersion() == DIA_SUCCESS) { // One time request to get the actual value

               DIA_TR_INF("dia_SrvHandler_DataCarrierVersionRead::subscribeForNavigationInfo getDatasetVersion() OK!");

            } else {
               DIA_TR_ERR("dia_SrvHandler_DataCarrierVersionRead::subscribeForNavigationInfo getDatasetVersion() with ERRORS!");
               (tVoid) unsetSysAdapterListener<dia_IHMINavigationListener>(this);
               return DIA_FAILED;
            }
         }
         else {
            DIA_TR_ERR("dia_SrvHandler_DataCarrierVersionRead::subscribeForNavigationInfo registerToDatasetVersion() with ERRORS!");
            (tVoid) unsetSysAdapterListener<dia_IHMINavigationListener>(this);
            return DIA_FAILED;
         }

      }
   }
   else {
      DIA_TR_ERR("dia_SrvHandler_DataCarrierVersionRead::subscribeForNavigationInfo querySysAdapterInterface<dia_IHMINavigationListener> ERROR!");
   }

   return DIA_SUCCESS;
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_DataCarrierVersionRead::vOnDataSetVersionStatus (const std::string& dataSetVersion)
{
   dia_tclFnctTrace trc("dia_SrvHandler_DataCarrierVersionRead::vOnDataSetVersionStatus");
   DIA_TR_INF("dia_SrvHandler_DataCarrierVersionRead:: DataSetVersion Received: %s", dataSetVersion.c_str() );

   tU16 DataSetVersion_length= 0;
   (void) unsetSysAdapterListener<dia_IHMINavigationListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   DataSetVersion_length=dataSetVersion.size();
   DIA_TR_INF("dia_SrvHandler_DataCarrierVersionRead:: DataSetVersion Length: %d", DataSetVersion_length );
   DIA_TR_INF("dia_SrvHandler_DataCarrierVersionRead:: DataSetVersion Received: %s", dataSetVersion.c_str() );

   for (tU16 i = 0; i < DataSetVersion_length; i++)
   {
      (void) oDiagMsgBuffer().vSetDataU8((tU16) DATA_START + 0+ i, dataSetVersion[i]); 
   }

   vResReadyAndQuit();
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_DataCarrierVersionRead::vOnTimeout()
{
   dia_tclFnctTrace trc("dia_SrvHandler_DataCarrierVersionRead::vOnTimeout()");

   (void) unsetSysAdapterListener<dia_IHMINavigationListener>(this);

   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}

//-------------------------------------------------------------------------------