/*
 * dia_SrvHandler_Antenna3Parameter.cpp
 *
 *  Created on: 08.05.2017
 *      Author: stc2hi
 */
// TTFis:\> DIA_REQ UDS 03 22 30 03

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SrvHandler_Antenna3Parameter.h"

#define DATA_START 3
#define DATA_LENGTH 27

//-----------------------------------------------------------------------------

dia_SrvHandler_Antenna3Parameter::dia_SrvHandler_Antenna3Parameter ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_Antenna3Parameter", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_AIVI_ANTENNA3_PARAMETER_DAB)
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna3Parameter::dia_SrvHandler_Antenna3Parameter(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_Antenna3Parameter::~dia_SrvHandler_Antenna3Parameter ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_ITunerDABListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_Antenna3Parameter::~dia_SrvHandler_Antenna3Parameter !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_Antenna3Parameter::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna3Parameter::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ITunerDAB* pInterface = 0;
   if ((querySysAdapterInterface<dia_ITunerDAB>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_ITunerDABListener>(this);
      if (pInterface->tunerDABTestmode_Set(TRUE) == DIA_SUCCESS)
      {
         if (pInterface->tunerDABTestModeData_Get() == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_SrvHandler_Antenna3Parameter::vProcessRequest - tunerDABTestModeData_Get() failed.");
         }
      }
      else
      {
         DIA_TR_INF("dia_SrvHandler_Antenna3Parameter::vProcessRequest - tunerDABTestmode_Set() failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_Antenna3Parameter::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_ITunerDABListener>(this);
      DIA_TR_ERR("dia_SrvHandler_Antenna3Parameter ---  SEND TO SensorPV SERVER FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Antenna3Parameter::vOnTunerDABTestModeData ( const dia_tDABTestModeData& mode )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna3Parameter::vOnTunerDABTestModeData");

//   (void) unsetSysAdapterListener<dia_ITunerDABListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, mode.m_s8FieldStrength); //antenna field RSSI [dBm]
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, (mode.m_u32BERofFIC >> 8) & 0xFF); //FIC BER
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 2, (mode.m_u32BERofFIC >> 0) & 0xFF); //FIC BER
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 3, (mode.m_u32BERofMSC >> 8) & 0xFF); //MSC BER
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 4, (mode.m_u32BERofMSC >> 0) & 0xFF); //MSC BER
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 5, ' '); //Current Channel Number
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 6, ' '); //Current Channel Number
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 7, ' '); //Current Channel Number
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 8, ' '); //Current Channel Number
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 9, ' '); //Current Channel Number
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 10, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 11, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 12, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 13, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 14, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 15, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 16, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 17, ' '); //Service short Name
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 18, 0); //Ensemble ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 19, 0); //Ensemble ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 20, (mode.m_u32ServiceId >> 24) & 0xFF); //Service ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 21, (mode.m_u32ServiceId >> 16) & 0xFF); //Service ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 22, (mode.m_u32ServiceId >> 8) & 0xFF); //Service ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 23, (mode.m_u32ServiceId >> 0) & 0xFF); //Service ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 24, 0); //Comp ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 25, 0); //Comp ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 26, 0x04); //ANT3 Band Info (4: DAB)

#if 0
   dia_ITunerDAB* pInterface = 0;
   if ((querySysAdapterInterface<dia_ITunerDAB>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      pInterface->tunerDABChannelInfo_Get();
      pInterface->tunerDABActiveEnsemleInfo_Get();
   }
#endif

   dia_ITunerDAB* pInterface = 0;
   if ((querySysAdapterInterface<dia_ITunerDAB>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      pInterface->tunerDABActiveServiceInfo_Get();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Antenna3Parameter::vOnTunerDABActiveServiceInfo ( const dia_tTunerDABActSrvInfo& info )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna3Parameter::vOnTunerDABActiveServiceInfo");

   for (tU16 i = 0; i < ((info.dataServiceLabel.strLen < 8)? info.dataServiceLabel.strLen: 8); i++)
   {
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 10 + i, info.dataServiceLabel.string[i]); //Service short Name
   }

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 20, (info.dataServiceId >> 24) & 0xFF); //Service ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 21, (info.dataServiceId >> 16) & 0xFF); //Service ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 22, (info.dataServiceId >> 8) & 0xFF); //Service ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 23, (info.dataServiceId >> 0) & 0xFF); //Service ID

   dia_ITunerDAB* pInterface = 0;
   if ((querySysAdapterInterface<dia_ITunerDAB>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      pInterface->tunerDABStatus_Get();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Antenna3Parameter::vOnTunerDABStatus ( const dia_tTunerDABStatus& status )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna3Parameter::vOnTunerDABStatus");

   for (tU16 i = 0; i < ((status.freqLabel.strLen < 5)? status.freqLabel.strLen: 5); i++)
   {
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 5 + i, status.freqLabel.string[i]); //Current Channel Number
   }

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 18, (status.ensembleID >> 8) & 0xFF); //Ensemble ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 19, (status.ensembleID >> 0) & 0xFF); //Ensemble ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 24, (status.componentID >> 8) & 0xFF); //Comp ID
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 25, (status.componentID >> 0) & 0xFF); //Comp ID

   (void) unsetSysAdapterListener<dia_ITunerDABListener>(this);
   vResReadyAndQuit();
}

