/*
 * dia_SrvHandler_Antenna2Parameter.cpp
 *
 *  Created on: 08.05.2017
 *      Author: stc2hi
 */
// TTFis:\> DIA_REQ UDS 03 22 30 02

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SrvHandler_Antenna2Parameter.h"

#define DATA_START 3
#define DATA_LENGTH 8

//-----------------------------------------------------------------------------

dia_SrvHandler_Antenna2Parameter::dia_SrvHandler_Antenna2Parameter ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_Antenna2Parameter", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_AIVI_ANTENNA2_PARAMETER_FM2)
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna2Parameter::dia_SrvHandler_Antenna2Parameter(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_Antenna2Parameter::~dia_SrvHandler_Antenna2Parameter ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_ITunerTestmodeListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_Antenna2Parameter::~dia_SrvHandler_Antenna2Parameter !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_Antenna2Parameter::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna2Parameter::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ITunerTestmode* pInterface = 0;
   if ((querySysAdapterInterface<dia_ITunerTestmode>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_ITunerTestmodeListener>(this);
      if (pInterface->controlTestmode(TRUE) == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_INF("dia_SrvHandler_Antenna2Parameter::vProcessRequest - controlTestmode() failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_Antenna2Parameter::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_ITunerTestmodeListener>(this);
      DIA_TR_ERR("dia_SrvHandler_Antenna2Parameter ---  SEND TO Tuner SERVER FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Antenna2Parameter::vOnControlTestmode()
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna2Parameter::vOnControlTestmode");
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Antenna2Parameter::vOnTestmodeData(const dia_ITunerTestmodeData& data)
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna2Parameter::vOnTestmodeData");

   if (data.ePhysicalTuner == DIA_EN_AMFMTUNER_1)
   {
      (void) unsetSysAdapterListener<dia_ITunerTestmodeListener>(this);

      DIA_TR_INF("dia_SrvHandler_Antenna2Parameter::vOnTestmodeData - data.ePhysicalTuner=DIA_EN_AMFMTUNER_1");

      dia_ITunerTestmode* pInterface = 0;
      if ((querySysAdapterInterface<dia_ITunerTestmode>(&pInterface) == DIA_SUCCESS) && pInterface)
      {
         (void) pInterface->controlTestmode(FALSE);
      }

      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, data.u8Fieldstrength); //FieldStrength Antenna2
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, data.u8Multipath); //Multipath level
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 2, data.u8Quality); //Noise level
      tU32 f = data.u32AFFrequency;
      f *= 1000;
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 3, (f >> 24) & 0xFF); //Frequency Value
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 4, (f >> 16) & 0xFF); //Frequency Value
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 5, (f >> 8) & 0xFF); //Frequency Value
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 6, (f >> 0) & 0xFF); //Frequency Value
      if (data.eBand == DIA_EN_AMFMTUNER_BAND_AM)
      {
         (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 7, 2); //Band Info
      }
      else if (data.eBand == DIA_EN_AMFMTUNER_BAND_FM)
      {
         (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 7, 1); //Band Info
      }
      else
      {
         (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 7, 0); //Band Info
      }

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_Antenna2Parameter::vOnTestmodeData - data.ePhysicalTuner=%d, but exp %d.", data.ePhysicalTuner, DIA_EN_AMFMTUNER_1);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Antenna2Parameter::vOnTimeout ( void )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Antenna2Parameter::vOnTimeout()");

   dia_ITunerTestmode* pInterface = 0;
   if ((querySysAdapterInterface<dia_ITunerTestmode>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      DIA_TR_INF("dia_SrvHandler_Antenna2Parameter::vOnTimeout pInterface not NULL.");
      if (DIA_SUCCESS!=pInterface->controlTestmode(FALSE))
      {
         DIA_TR_ERR("dia_SrvHandler_Antenna2Parameter::vOnTimeout controlTestmode(FALSE) unsuccessful.");
      }
      else
      {
         DIA_TR_INF("dia_SrvHandler_Antenna2Parameter::vOnTimeout controlTestmode(FALSE) successful.");
      }
   }

   (void) unsetSysAdapterListener<dia_ITunerTestmodeListener>(this);
   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}

