/*!
 * \file       dia_SrvHandlerVideoFileCounter.h
 *
 * \brief      Service handler that will read the video file counter Status
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Raksha Rao (RBEI/ECA2)
 *
 * \date       13.09.2021
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_VIDEO_FILE_COUNTER__
#define __INCLUDED_DIA_SRV_HANDLER_RDID_VIDEO_FILE_COUNTER__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER_LISTENER__
#include "project/interfaces/dia_IMediaFileCounterListener.h"
#endif

class dia_SrvHandlerVideoFileCounter
   : public dia_ServiceHandlerUDS,
     public dia_IMediaFileCounterListenerImpl
{
  DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerVideoFileCounter);
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerVideoFileCounter);

public:
   //! class constructor
   dia_SrvHandlerVideoFileCounter ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandlerVideoFileCounter ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

   //! reply on getting vOnVideoFile_noOfFilesCounter_Get status
   virtual void vOnVideoFile_noOfFilesCounter_Get (  tU32 noOfVideoFiles /*status*/ );

};

#endif /* __INCLUDED_DIA_SRV_HANDLER_RDID_VIDEO_FILE_COUNTER__ */