/*!
 * \file       dia_SrvHandlerVideoFileCounter.cpp
 *
 * \brief      Service handler that will read the video file counter Status
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Raksha Rao (RBEI/ECA2)
 *
 * \date       13.09.2021
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_VIDEO_FILE_COUNTER__
#include "project/services/customer/dia_SrvHandlerVideoFileCounter.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 4
//-----------------------------------------------------------------------------

dia_SrvHandlerVideoFileCounter::dia_SrvHandlerVideoFileCounter ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerVideoFileCounter::dia_SrvHandlerVideoFileCounter");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerVideoFileCounter::~dia_SrvHandlerVideoFileCounter ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IMediaFileCounterListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerVideoFileCounter::~dia_SrvHandlerVideoFileCounter !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandlerVideoFileCounter::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerVideoFileCounter::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IMediaFileCounter* pInterface = NULL;
   if ((querySysAdapterInterface<dia_IMediaFileCounter>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IMediaFileCounterListener>(this);

      if (pInterface->mediaFile_noOfFilesCounter_Get() == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_INF("dia_SrvHandlerVideoFileCounter::vProcessRequest - videoFile_noOfFilesCounter_Get() failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandlerVideoFileCounter::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_IMediaFileCounterListener>(this);
      DIA_TR_ERR("dia_SrvHandlerVideoFileCounter ---  SEND TO INTERFACE FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerVideoFileCounter::vOnVideoFile_noOfFilesCounter_Get (tU32 noOfVideoFiles)
{
   dia_tclFnctTrace trc("dia_SrvHandlerVideoFileCounter::vOnVideoFile_noOfFilesCounter_Get");

   DIA_TR_INF("dia_SrvHandlerVideoFileCounter:: Video File Counter Received: %ld ", noOfVideoFiles );

   tU32 VideoFileCounter = 0;
   (void) unsetSysAdapterListener<dia_IMediaFileCounterListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
   VideoFileCounter= noOfVideoFiles;

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, (VideoFileCounter >> 24) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, (VideoFileCounter >> 16) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 2, (VideoFileCounter  >> 8) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 3, (VideoFileCounter  >> 0) & 0xFF); 

   vResReadyAndQuit();
}