#ifndef __DIA_SRV_HANDLER_VEHICLE_INFORMATION_H__
#define __DIA_SRV_HANDLER_VEHICLE_INFORMATION_H__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

namespace tinyxml2 
{
class XMLElement;
class XMLNode;
}
using namespace tinyxml2;
namespace dia {

/**
 * \class   dia_SrvHandlerVehicleInformation
 *
 * \brief   service handler to process read request for
 *          Software Version of CIS Installation Container
 *
 * \ingroup diaServicesproj
 */
class dia_SrvHandlerVehicleInformation
      : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerVehicleInformation);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    *
    * \return     none
    */
   dia_SrvHandlerVehicleInformation(tCString name, tU8 sid, tU16 did);

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandlerVehicleInformation(void);
   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  vecArgs      request buffer
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<void*>&  /* vecArgs */);

private:
   /**
    *
    * \brief      method called to parse xml
    *
    *             This method is used to parse the xml file.
    *             
    * \param[in]  file      xml file path
    *
    * \return     none
    */
   virtual void parseXML( const std::string& /* file */ ); 
   /**
    *
    * \brief      member variable to store VehicleInfo version data
    *
    */
   std::string __VehicleInfo;
   /**
    *
    * \brief      member variable to store parsing result
    *
    */
   tBool __VehicleInfoFound;
};

} /* namespace dia */

#endif /* ___DIA_SRV_HANDLER_VEHICLE_INFORMATION_H__ */
