
#ifndef __DIA_SRV_HANDLER_VEHICLE_INFORMATION_H__
#include "project/services/customer/dia_SrvHandlerVehicleInformation.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#include <sstream>
#include <common/framework/xml/tinyxml2.h>

using namespace tinyxml2;

namespace dia {

#define DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))
#define DIA_U16_SCRIPT_VALUE_DATA_LENGTH  ((tU16) (4))

static const std::string targetXMLpath  ("/var/opt/bosch/persistent/avdecc/doipcmcinstallresult.xml");
static const std::string targetNodeName ("result");
static const std::string defaultVehicleInfo ("000000");

//------------------------------------------------------------------------------

dia_SrvHandlerVehicleInformation::dia_SrvHandlerVehicleInformation ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name, sid, did),
     __VehicleInfo(defaultVehicleInfo),
     __VehicleInfoFound(FALSE)
{
   dia_tclFnctTrace trc("dia_SrvHandlerVehicleInformation::dia_SrvHandlerVehicleInformation(tCString,tU8,tU16)");
}

//------------------------------------------------------------------------------

dia_SrvHandlerVehicleInformation::~dia_SrvHandlerVehicleInformation ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandlerVehicleInformation::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerVehicleInformation::vProcessRequest(...)");

   __VehicleInfo = defaultVehicleInfo;
   __VehicleInfoFound = FALSE;

   parseXML(targetXMLpath);	
   if ( !__VehicleInfoFound)
   {
      DIA_TR_ERR("### dia_SrvHandlerVehicleInformation::vProcessRequest error detected!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

   vResReadyAndQuit();
}

//------------------------------------------------------------------------------

/**
*
* \brief      method called to parse xml
*
*             This method is used to parse the xml file.
*             
* \param[in]  file      xml file path
*
* \return     none
*/
void
dia_SrvHandlerVehicleInformation::parseXML ( const std::string& file )
{
   ScopeTrace oTrace("dia::dia_SrvHandlerVehicleInformation::parseXML(...)");

   XMLDocument xmlDoc;
   XMLError retCode = xmlDoc.LoadFile(file.c_str());

   if(XML_SUCCESS == retCode)
   {
      size_t found = file.find_last_of("/\\");
      std::string FileName = file.substr(found+1);
      std::string FilePath = file.substr(0,found);

      DIA_TR_INF("+------------------------------+");
      DIA_TR_INF("| START PARSING OF XML CONTENT |");
      DIA_TR_INF("+------------------------------+");
      DIA_TR_INF("");
      DIA_TR_INF("+ PATH: \"%s\"",FilePath.c_str());
      DIA_TR_INF("+ FILE: \"%s\"",FileName.c_str());

      XMLElement* root = xmlDoc.RootElement();
      if ( root )
      {
         DIA_TR_INF("Enter in node");
         std::string nodeName = root->ToElement()->Value();
         DIA_TR_INF("XML-Node: %s", nodeName.c_str());
         DIA_TR_INF("After getting nodename");

         /*current xml file has first element as root*/
         if(nodeName == targetNodeName)
         {
            /*extracting the data of result scripts*/
            const char* Attrdata =  root->ToElement()->Attribute("scripts");
            if(Attrdata)
            {
               DIA_TR_INF("search for attrdata");
               std::string __VehicleInfo = std::string(Attrdata);
               DIA_TR_INF("scriptValue: \"%s\"",__VehicleInfo.c_str());
               __VehicleInfoFound = TRUE;
               char buffer[4];
               strcpy(buffer, __VehicleInfo.c_str());
               oDiagMsgBuffer().vSetPosResp();
               oDiagMsgBuffer().vSetDataLength(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH + DIA_U16_SCRIPT_VALUE_DATA_LENGTH);
               for ( tU16 i=0; i<4; i++ )
               {
                  (void) oDiagMsgBuffer().vSetDataU8(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH+i,(tU8) buffer[i]);
               }
            }
         }
         else
         {
            DIA_TR_ERR("### dia_SrvHandlerVehicleInformation::parseXML Target Node mismatching--Expected :'result',Observed:%s!",nodeName.c_str());
         }
      }
      else
      {
            DIA_TR_ERR("### dia_SrvHandlerVehicleInformation::parseXML invalid RootElement found!");
      }
   }

}

} /* namespace dia */
