/*!
 * \file       dia_SrvHandlerVINIdentWrite.h
 *
 * \brief      Service Handler for writing VIN
 *
 * \details    VIN writing is allowed without Customer Security Access if:
 *             1/ current VIN is not available, or
 *             2/ all bytes of current VIN are 0x30.
 *
 *             VIN writing is possible (with or without Customer Security Access) only if incoming VIN is different than following patterns:
 *             1/ all bytes of VIN are 0x00
 *             2/ all bytes of VIN are 0x30
 *             3/ all bytes of VIN are 0xFF
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_SERVICE_HANDLER_VIN_IDENT_WRITE__
#define __INCLUDED_SERVICE_HANDLER_VIN_IDENT_WRITE__

#ifndef dia_SrvHandlerGenericIdentWrite_H_
#include "common/services/uds/generic/dia_SrvHandlerGenericIdentWrite.h"
#endif

class dia_SrvHandlerVINIdentWrite
   : public dia_SrvHandlerGenericIdentWrite
{
public:
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerVINIdentWrite);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerVINIdentWrite);

public:
   //! class constructor
   dia_SrvHandlerVINIdentWrite ( tCString name, tU8 sid, tU16 did );
   //! class destructor
   virtual ~dia_SrvHandlerVINIdentWrite ( void );

   //! process the received request
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

protected:
	tDiaResult checkCustSecurityLevelUnlocked ( void ) const;
};

#endif /* __INCLUDED_SERVICE_HANDLER_VIN_IDENT_WRITE__ */
