/*
 * dia_SrvHandlerTemperatureHistogramRead.cpp
 *
 *  Created on: Mar 28, 2019
 *      Author: mky6kor
 */
#ifndef __DIA_SRVHANDLER_TEMPERATURE_HISTOGRAM_READ__
#include "project/services/customer/dia_SrvHandlerTemperatureHistogramRead.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM__
#include "common/interfaces/dia_ITemperatureHistogram.h"
#endif
#define DIA_TEMPERATURE_HISTOGRAM_MAX_MIN (uint16_t)2
#define DIA_TEMPERATURE_RESOLUTION        (int16_t)10
namespace dia {
dia_SrvHandlerTemperatureHistogramRead::dia_SrvHandlerTemperatureHistogramRead(tCString name, tU8 sid, tU16 did , dia_eHeatCtrlTemperatureID temperatureID) :
dia_SrvHandlerGenericTemperatureHistogramRead(name,sid,(tU16) did,temperatureID)
{
	// TODO Auto-generated constructor stub
	dia_tclFnctTrace trc("dia_SrvHandlerTemperatureHistogramRead::dia_SrvHandlerTemperatureHistogramRead(void)");
}

dia_SrvHandlerTemperatureHistogramRead::~dia_SrvHandlerTemperatureHistogramRead() {
	// TODO Auto-generated destructor stub
	("dia_SrvHandlerTemperatureHistogramRead::~dia_SrvHandlerTemperatureHistogramRead(void)");
}
//----------------------------------------------------------------------------
void
dia_SrvHandlerTemperatureHistogramRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
	dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest(vecArgs);
}
//-----------------------------------------------------------------------------
void
dia_SrvHandlerTemperatureHistogramRead::onTemperatureHistogram (dia_tTemperatureHistogram const &histogram)
{
   dia_tclFnctTrace trc("dia_SrvHandlerTemperatureHistogramRead::onTemperatureHistogram");

   (void) unsetSysAdapterListener<ITemperatureHistogramListener>(this);

   uint8_t nrc=DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT;
   DIA_TR_INF("dia_SrvHandlerTemperatureHistogramRead::onTemperatureHistogram(): id=%u", histogram.mId);
   if (histogram.mId != mTemperatureID) {
      DIA_TR_INF("dia_SrvHandlerTemperatureHistogramRead::onTemperatureHistogram: wrong id");
   }

   else if ( !histogram.mData )
   {
      DIA_TR_INF("dia_SrvHandlerTemperatureHistogramRead::onTemperatureHistogram: no data");
   }
   else {
      nrc=DIA_SUCCESS;
   }

   if (nrc != DIA_SUCCESS) {
      oDiagMsgBuffer().vSetNegResp(nrc);
      vResReadyAndQuit();
      return;
   }

   // assemble response, set len and enforce format_raw
   oDiagMsgBuffer().vSetDataLength(3 + DIA_TEMPERATURE_HISTOGRAM_MAX_MIN * 2 +DIA_TEMPERATURE_HISTOGRAM_LENGTH * 4);

   std::array<uint32_t, DIA_TEMPERATURE_HISTOGRAM_LENGTH> const &input=*(histogram.mData);

   tU8 u8DataPos=0;
   tS16 TemperatureMin = histogram.mTemperatureMin * DIA_TEMPERATURE_RESOLUTION;
   tS16 TemperatureMax = histogram.mTemperatureMax * DIA_TEMPERATURE_RESOLUTION;
   //    (void) oDiagMsgBuffer().vSetDataU8(u8DataPos, sid);
   oDiagMsgBuffer().vSetPosResp();
   u8DataPos=(uint8_t)(u8DataPos+1);
   //(void) oDiagMsgBuffer().setDataU32BigEndian(u8DataPos, did);
  u8DataPos=(uint8_t)(u8DataPos+2);
   (void) oDiagMsgBuffer().setDataU16BigEndian(u8DataPos,TemperatureMin);
   u8DataPos=(uint16_t)(u8DataPos+2);
   (void) oDiagMsgBuffer().setDataU16BigEndian(u8DataPos,TemperatureMax);
   u8DataPos=(uint16_t)(u8DataPos+2);
   for (std::array<uint32_t, DIA_TEMPERATURE_HISTOGRAM_LENGTH>::const_iterator iter = input.begin();
        iter != input.end();
        ++iter )
   {
      DIA_TR_INF("dia_SrvHandlerTemperatureHistogramRead::onTemperatureHistogram(): add temp %u", *iter);
      (void) oDiagMsgBuffer().setDataU32BigEndian(u8DataPos, (*iter) * 60);
      u8DataPos=(uint8_t)(u8DataPos+4);
   }
   DIA_TR_INF("dia_SrvHandlerTemperatureHistogramRead::Buffer size is 0x%02x(%d)",oDiagMsgBuffer().u16GetDataLength(),oDiagMsgBuffer().u16GetDataLength());
   vResReadyAndQuit();
}
}
