/*!
 * \file       dia_SrvHandlerSpeechControlCounter.cpp
 *
 * \brief      Service handler that will read the Speech COntrol Counter
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Naik Ravi (MS/ECA2-XC)
 *
 * \date       26.11.2021
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif
#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_PROJECTCONFIG_
#include <project/framework/config/dia_defsProjectConfig.h>
#endif
#ifndef __INCLUDED_DIA_SRV_HANDLER_SPEECH_CONTROL_COUNTER__
#include "project/services/customer/dia_SrvHandlerSpeechControlCounter.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 4
#define DATA_SIZE 4


//-----------------------------------------------------------------------------

dia_SrvHandlerReadSPeechControlCounter::dia_SrvHandlerReadSPeechControlCounter ( tCString name, tU8 sid, tU16 did )
    : dia_ServiceHandlerUDS(name,sid,did)
{
	dia_tclFnctTrace trc("dia_SrvHandlerReadSPeechControlCounter::dia_SrvHandlerReadSPeechControlCounter");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerReadSPeechControlCounter::~dia_SrvHandlerReadSPeechControlCounter ( void )
{
    _BP_TRY_BEGIN
    {

    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerReadSPeechControlCounter::~dia_SrvHandlerReadSPeechControlCounter !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandlerReadSPeechControlCounter::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerReadSPeechControlCounter::vProcessRequest");

   tU8 u8data[4] = {0};
      (void) ::memset(u8data, 0, 4);

      tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP)) );

      DIA_TR_INF("dia_SrvHandlerReadSPeechControlCounter::vProcessRequest u8data [0] = 0x%02x", u8data [0]);
      DIA_TR_INF("dia_SrvHandlerReadSPeechControlCounter::vProcessRequest u8data [1] = 0x%02x", u8data [1]);
      DIA_TR_INF("dia_SrvHandlerReadSPeechControlCounter::vProcessRequest u8data [2] = 0x%02x", u8data [2]);
      DIA_TR_INF("dia_SrvHandlerReadSPeechControlCounter::vProcessRequest u8data [3] = 0x%02x", u8data [3]);

      if ( retCode != DIA_SUCCESS )
      {
         // Sending back the Negative answer
         DIA_TR_INF("dia_SrvHandlerReadSPeechControlCounter: FAILED (READ DATA FROM PERSISTENT MEMORY) !!");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      }
      else
      {
         // Sending back the positive answer
         DIA_TR_INF("dia_SrvHandlerReadSPeechControlCounter: SUCCEEDED");
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(DATA_START+4);
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START+0, (tU8)u8data [3]);
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1, (tU8)u8data [2]);
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START+2, (tU8)u8data [1]);
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START+3, (tU8)u8data [0]);
         vResReadyAndQuit();
      }
}

//-----------------------------------------------------------------------------

