/*!
 * \file       dia_SrvHandlerSoftwareSupplierIdentRead.h
 *
 * \brief      Service Handler for reading Software Supplier Information
 *
 * \details    Header file
 *             
 * \author     Hme4kor
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_SERVICE_HANDLER_SOFTWARE_SUPPLIER_IDENT_READ__
#define __INCLUDED_SERVICE_HANDLER_SOFTWARE_SUPPLIER_IDENT_READ__

#ifndef __INCLUDED_SERVICE_HANDLER_GENERIC_IDENT_READ__
#include "common/services/uds/generic/dia_SrvHandlerGenericIdentRead.h"
#endif

class dia_SrvHandlerSoftwareSupplierIdentRead
   : public dia_SrvHandlerGenericIdentRead
{
public:
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerSoftwareSupplierIdentRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerSoftwareSupplierIdentRead);

public:
   //! class constructor
   dia_SrvHandlerSoftwareSupplierIdentRead ( tCString name, tU8 sid, tU16 did );
   //! class destructor
   virtual ~dia_SrvHandlerSoftwareSupplierIdentRead ( void );

   //! process the received request
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );
};

#endif /* __INCLUDED_SERVICE_HANDLER_SOFTWARE_SUPPLIER_IDENT_READ__ */
