/*!
 * \file       dia_SrvHandlerRuntimeSourceAM.cpp
 *
 * \brief      Service handler that will read the Runtime Source AM
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    production diagnosis
 *
 * \author     Naik Ravi (MS/ECA2-XC)
 *
 * \date       6.12.2021
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_SW_DWONLOAD_PRIVATE_KEY__
#include "project/services/customer/dia_SrvHandlerSWDownloadPrivateKey.h"
#endif


#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <fstream>     //lint !e537 : repeatedly included header file without standard include guard
#include <stdlib.h>    //lint !e537 !e451 : repeatedly included header file without standard include guard
#include <sys/wait.h>

///var/opt/bosch/persistent/id/privkey.pem.wrap
static const std::string SW_DWONLOAD_WARP_PRIVATE_KEY_PATH ("/var/opt/bosch/persistent/id/privkey.pem.wrap");

#define DATA_START 3
#define DATA_LENGTH 1
#define PRIVATE_KEY_EXIST_STATUS		0x01
#define PRIVATE_KEY_NOT_EXIST_STATUS	0x00


//-----------------------------------------------------------------------------

dia_SrvHandlerReadSWDownloadPrivateKey::dia_SrvHandlerReadSWDownloadPrivateKey ( tCString name, tU8 sid, tU16 did )
    : dia_ServiceHandlerUDS(name,sid,did)
{
	dia_tclFnctTrace trc("dia_SrvHandlerReadSWDownloadPrivateKey::dia_SrvHandlerReadSWDownloadPrivateKey");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerReadSWDownloadPrivateKey::~dia_SrvHandlerReadSWDownloadPrivateKey ( void )
{
    _BP_TRY_BEGIN
    {

    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerReadSWDownloadPrivateKey::~dia_SrvHandlerReadSWDownloadPrivateKey !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandlerReadSWDownloadPrivateKey::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerReadSWDownloadPrivateKey::vProcessRequest");

   tU8 privatekeystatus= PRIVATE_KEY_NOT_EXIST_STATUS;

   dia_File swDownloadPrivateKey(SW_DWONLOAD_WARP_PRIVATE_KEY_PATH);
   if(swDownloadPrivateKey.doesExist())
   {
     DIA_TR_INF("Read SW Download Private Key Path exist !!!");
     privatekeystatus= PRIVATE_KEY_EXIST_STATUS;
   }
   else
   {
     DIA_TR_INF("Read SW Download Private Key Path does not exist !!!");
     privatekeystatus= PRIVATE_KEY_NOT_EXIST_STATUS;

   }

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength( DATA_START + DATA_LENGTH);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START , privatekeystatus );
   vResReadyAndQuit();
}

//-----------------------------------------------------------------------------

