/*!
 * \file       dia_SrvHandlerReadSubsystemNodeList.h
 *
 * \brief      Service handler that will read the current Subsystem node list data
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Ravi Naik (RBEI/ECA2)
 *
 * \date       08.09.2021
 *
 * \copyright  (c) 2021 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_SUB_SYSTEM_NODE_LIST__
#define __INCLUDED_DIA_SRV_HANDLER_RDID_SUB_SYSTEM_NODE_LIST__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CMC_DOIP_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif
class dia_SrvHandlerReadSubsystemNodeList
   : public dia_ServiceHandlerUDS,
     public dia_ISubsystemDiagnosisListenerImpl
{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerReadSubsystemNodeList);
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerReadSubsystemNodeList);

public:
   //! class constructor
    dia_SrvHandlerReadSubsystemNodeList ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandlerReadSubsystemNodeList ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

   //! reply on getting current cvbs connection status
   virtual void vOnReadSubsystemsNodeListRequestUpdate  (const std::list<dia_tSubsystemInfo>& nodeList);

};

#endif /* __INCLUDED_DIA_SRV_HANDLER_RDID_SUB_SYSTEM_NODE_LIST__ */
