/*!
 * \file       dia_SrvHandlerReadSubsystemNodeList.cpp
 *
 * \brief      Service handler that will read the current subbsystem node list
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Ravi Naik (RBEI/ECA2)
 *
 * \date       08.09.2021
 *
 * \copyright  (c) 2021 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManager.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_SUB_SYSTEM_NODE_LIST__
#include "project/services/customer/dia_SrvHandlerReadSubsystemNodeList.h"
#endif


#define DATA_START (1/*sizeof(SID)*/ + mDIDLen)
#define DATA_LENGTH (DIA_C_SUBSYSTEM_IDENTIFY_ENTITIES_RESP_MAX_NUM_SUBSYSTEMS * 6)
//-----------------------------------------------------------------------------

dia_SrvHandlerReadSubsystemNodeList::dia_SrvHandlerReadSubsystemNodeList ( tCString name, tU8 sid, tU16 did )
    : dia_ServiceHandlerUDS(name,sid,did)
{
	dia_tclFnctTrace trc("dia_SrvHandlerReadSubsystemNodeList::dia_SrvHandlerReadSubsystemNodeList");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerReadSubsystemNodeList::~dia_SrvHandlerReadSubsystemNodeList ( void )
{
/*	_BP_TRY_BEGIN
    {
		DIA_TR_INF("dia_SrvHandlerReadSubsystemNodeList::~dia_SrvHandlerReadSubsystemNodeList - unregisterSessionChange");
		(void)unregisterSessionChange();
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerReadSubsystemNodeList::~dia_SrvHandlerReadSubsystemNodeList !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
	*/
}

//-------------------------------------------------------------------------------

void
dia_SrvHandlerReadSubsystemNodeList::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
    dia_tclFnctTrace trc("dia_SrvHandlerReadSubsystemNodeList::vProcessRequest");

    tBool errorDetected = TRUE;

	//! get the instance of subsystem manager
	dia_SubsystemDiagnosisManager* pSubManager = getInstanceOfSubsystemDiagnosisManager();

	if( !pSubManager )
	{
		// Sending back the negative response since Subsystem manager is not available
		DIA_TR_ERR("dia_SrvHandlerReadSubsystemNodeList::start FAILED (NO ACCESS TO SUBSYSTEM MANAGER) !!");
	}
	else
	{	
		//! Set the listener to get informed about the identified Subsystem later
		if (setSysAdapterListener<dia_ISubsystemDiagnosisListener>(this) == DIA_SUCCESS)
		{
			(void)pSubManager->readSubsystemNodeList();
			errorDetected = FALSE;
		}
		else
		{
			DIA_TR_ERR("dia_SrvHandlerReadSubsystemNodeList --> querySysAdapterInterface returned NULL PTR");
		}

	}

   if (errorDetected)
   {
	  (void) unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
      DIA_TR_ERR("dia_SrvHandlerReadSubsystemNodeList ---  NO ACCESS TO SUBSYSTEM MANAGER FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandlerReadSubsystemNodeList::vOnReadSubsystemsNodeListRequestUpdate (const std::list<dia_tSubsystemInfo>& nodeList)
{
	dia_tclFnctTrace oTrace("dia_SrvHandlerReadSubsystemNodeList::vOnReadSubsystemsNodeListRequestUpdate");
	
	 oDiagMsgBuffer().vSetPosResp();
	 oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

	//vExtractAndFillNodeListData(nodeList);
	tU32 size = nodeList.size();
	tU16 count=0;

		std::list<dia_tSubsystemInfo>::const_iterator  iter = nodeList.begin();

		for ( ; iter != nodeList.end(); ++iter )
		{
			dia_tSubsystemInfo const &subsystem = *iter;
			DIA_TR_INF("subsystemSupplierName is 0x%04X",subsystem.subsystemEntityName);

			for(int i = DIA_C_SUBSYSTEM_ENTITY_NAME_LEN; i > 0 ; i--)
			{
				  (void) oDiagMsgBuffer().vSetDataU8 (DATA_START+count,(static_cast<tU8>(((subsystem.subsystemEntityName) >> (8 * (i-1))))));
				  count++;
			}

			DIA_TR_INF("subsystemIPAddress is 0x%08X",iter->subsystemIPAddress);
			for(int i = DIA_C_SUBSYSTEM_ENTITY_IP_ADDR_LEN; i > 0 ; i--)
			{
				(void) oDiagMsgBuffer().vSetDataU8 (DATA_START+count,(static_cast<tU8>(((subsystem.subsystemIPAddress) >> (8 * (i-1))))));
				count++;
			}

		}
         // update FF to remaining nodes
		for(int i = count; i < DATA_LENGTH; i++)
		{

			(void) oDiagMsgBuffer().vSetDataU8 (DATA_START+i,DIA_C_SUBSYSTEM_IDENTIFY_ENTITIES_RESP_DEFAULT_DATA);

		}

	(void) unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
	vResReadyAndQuit();
	DIA_TR_INF("dia_SrvHandlerReadSubsystemNodeList::vOnReadSubsystemsNodeListRequestUpdate SUCCESSFUL");

}


//-----------------------------------------------------------------------

