/*!
 * \file       dia_SrvHandlerPhoneBook_MaxContactEntries.h
 *
 * \brief      Service handler that will read the the MAx phone book contact entries
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Ravi Naik (RBEI/ECA2)
 *
 * \date       22.03.2021
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_PHONEBOOK_MAX_CONTACT_ENTRIES__
#define __INCLUDED_DIA_SRV_HANDLER_RDID_PHONEBOOK_MAX_CONTACT_ENTRIES__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ_LISTENER__
#include "project/interfaces/dia_IPhonebookPrjListener.h"
#endif

class dia_SrvHandlerPhoneBookMaxContactEntries
   : public dia_ServiceHandlerUDS,
     public dia_IPhonebookPrjListenerImpl
{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerPhoneBookMaxContactEntries);
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerPhoneBookMaxContactEntries);

public:
   //! class constructor
    dia_SrvHandlerPhoneBookMaxContactEntries ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandlerPhoneBookMaxContactEntries ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

   //! reply on getting current cvbs connection status
   virtual void vOnPhoneBook_MaxContactEntries_Get ( tU32 maxcontactentries /*status*/ );

};

#endif /* __INCLUDED_DIA_SRV_HANDLER_RDID_CVBS_CONNECTION_STATUS__ */
