/*!
 * \file       dia_SrvHandlerPhoneBook_MaxContactEntries.cpp
 *
 * \brief      Service handler that will read the MAx phone book contact entries
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Ravi Naik (RBEI/ECA2)
 *
 * \date       22.03.2021
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_PHONEBOOK_MAX_CONTACT_ENTRIES__
#include "project/services/customer/dia_SrvHandlerPhoneBook_MaxContactEntries.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 3


//-----------------------------------------------------------------------------

dia_SrvHandlerPhoneBookMaxContactEntries::dia_SrvHandlerPhoneBookMaxContactEntries ( tCString name, tU8 sid, tU16 did )
    : dia_ServiceHandlerUDS(name,sid,did)
{
	dia_tclFnctTrace trc("dia_SrvHandlerPhoneBookMaxContactEntries::dia_SrvHandlerPhoneBookMaxContactEntries");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerPhoneBookMaxContactEntries::~dia_SrvHandlerPhoneBookMaxContactEntries ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IPhonebookPrjListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerPhoneBookMaxContactEntries::~dia_SrvHandlerPhoneBookMaxContactEntries !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandlerPhoneBookMaxContactEntries::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerPhoneBookMaxContactEntries::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IPhonebookPrj* pInterface = NULL;
   if ((querySysAdapterInterface<dia_IPhonebookPrj>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IPhonebookPrjListener>(this);

      if (pInterface->phonBook_MaxContactEntries_Get() == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_INF("dia_SrvHandlerPhoneBookMaxContactEntries::vProcessRequest - phonBook_MaxContactEntries_Get() failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandlerPhoneBookMaxContactEntries::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_IPhonebookPrjListener>(this);
      DIA_TR_ERR("dia_SrvHandlerPhoneBookMaxContactEntries ---  SEND TO INTERFACE FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerPhoneBookMaxContactEntries::vOnPhoneBook_MaxContactEntries_Get (tU32 maxcontactentries)
{
   dia_tclFnctTrace trc("dia_SrvHandlerPhoneBookMaxContactEntries::vOnPhoneBook_MaxContactEntries_Get");

   DIA_TR_INF("dia_SrvHandlerPhoneBookMaxContactEntries:: Max Contact Entries Received: %d ", maxcontactentries );

    tU32 MaxContactEntries = 0;
   (void) unsetSysAdapterListener<dia_IPhonebookPrjListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
   MaxContactEntries = maxcontactentries;

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, (MaxContactEntries >> 16) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, (MaxContactEntries >> 8) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 2, (MaxContactEntries  >> 0) & 0xFF);
   

   vResReadyAndQuit();
}
