/*!
 * \file       dia_SrvHandlerGenericSessionControlAIVI.h
 *
 * \brief      Perform hard reset in case of session changed from Programming Session to Default Session.
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup    Service Handler for Session Switch
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_AIVI_H_
#define DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_AIVI_H_

#ifndef DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_H_
#include <common/services/uds/generic/dia_SrvHandlerGenericSessionControl.h>
#endif

class dia_SrvHandlerGenericSessionControlAIVI
    : public dia_SrvHandlerGenericSessionControl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_SrvHandlerGenericSessionControlAIVI);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericSessionControlAIVI);

public:
   //! class constructor that provides initial session
   dia_SrvHandlerGenericSessionControlAIVI ( tU8 initialSession );

   //! notification about session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );
};

#endif /* DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_AIVI_H_ */
