/*!
 * \file       dia_SrvHandlerGenericSessionControlAIVI.cpp
 *
 * \brief      Perform hard reset in case of session changed from Programming Session to Default Session.
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup    Service Handler for Session Switch
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include "common/framework/protocols/uds/dia_defsUds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#include "dia_SrvHandlerGenericSessionControlAIVI.h"

using namespace std;

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSessionControlAIVI::dia_SrvHandlerGenericSessionControlAIVI ( void )
   : dia_SrvHandlerGenericSessionControl()
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericSessionControlAIVI::dia_SrvHandlerGenericSessionControlAIVI()");
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSessionControlAIVI::dia_SrvHandlerGenericSessionControlAIVI ( tU8 initialSession )
   : dia_SrvHandlerGenericSessionControl(initialSession)
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericSessionControlAIVI::dia_SrvHandlerGenericSessionControlAIVI(tU8)");
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSessionControlAIVI::~dia_SrvHandlerGenericSessionControlAIVI ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericSessionControlAIVI::vOnSessionChanged ( tU8 newSession, tU8 oldSession )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSessionControlAIVI::vOnSessionChanged");

   //run base class code
   dia_SrvHandlerGenericSessionControl::vOnSessionChanged(newSession, oldSession);

   //make Hard reset in case of session changed from Programming to Default.
   if (  (DIA_C_U8_UDS_SESSION_PROGRAMMING==oldSession) &&
         (DIA_C_U8_UDS_SESSION_DEFAULT==newSession) )
   {
      DIA_TR_INF("::vOnSessionChanged old session is programming, new session is default.");

      tDiaResult diaResult = DIA_FAILED;

      //Perform flush for all bags.
      dia_ConfigManager* pConfigMgr = getInstanceOfConfigManager();
      if ( pConfigMgr )
      {
         DIA_TR_INF("dia_SrvHandlerGenericSessionControlAIVI::vOnSessionChanged - Flush for all bags");
         diaResult = pConfigMgr->forceFlush();
      }

      if (DIA_SUCCESS!=diaResult)
      {
         DIA_TR_ERR("dia_SrvHandlerGenericSessionControlAIVI::vOnSessionChanged - Flush FAILED with 0x%x.", diaResult);
         DIA_ASSERT_ALWAYS();
      }

#if 0
      //Execute HardReset
      dia_ISpm* pInterface = OSAL_NULL;
      diaResult = querySysAdapterInterface<dia_ISpm>(&pInterface);

      if (DIA_SUCCESS==diaResult)
      {
         if (pInterface)
         {
            DIA_TR_INF("::vOnSessionChanged got interface");

            if (pInterface->signalSystemReset(DIA_EN_SPM_CORE_RESTART_MODE_ECU_FAST) == DIA_SUCCESS)
            {
               DIA_TR_INF("::vOnSessionChanged SUCCESSFUL");
            }
            else
            {
               /* Error handling is impossible here: positive reply has been already sent. */
               DIA_TR_ERR("::vOnSessionChanged SEND TO SPM SERVER FAILED");
            }
         }
         else
         {
            DIA_TR_ERR("::vOnSessionChanged Interface is null unexpectedly.");
         }
      }
      else
      {
         DIA_TR_ERR("::vOnSessionChanged Interface for dia_ISpm not got.");
      }
#endif
   }
}
