/*
 * dia_SrvHandlerGenericIdentWriteAIVI.cpp
 *
 *  Created on: May 23, 2017
 *      Author: mky6kor
 */

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include "common/framework/protocols/uds/dia_defsUds.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IDENTWRITE__
#include "project/services/customer/dia_SrvHandlerGenericIdentWriteAIVI.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_PROJECTCONFIG_
#include <project/framework/config/dia_defsProjectConfig.h>
#endif
//OEM Types
#define DIA_U8_OEM_TYPE_NISSAN                   (tU8) 0x06
#define DIA_U8_OEM_TYPE_RENAULT                  (tU8) 0x08
#define DIA_U8_OEM_TYPE_INFINITI                 (tU8) 0x16

//CAN Activation Message Types
#define DIA_U8_MESSAGE_TYPE_NISSAN				 (tU8) 0x00
#define DIA_U8_MESSAGE_TYPE_RENAULT				 (tU8) 0x01

#define PROP_LENGTH      ((tU8) 64) //no. of bytes stored in the DiagMsgBufferUds
#define CONSISTENCY_CHECK_SUPPORT_DEFAULT ((tU8) 0)

dia_SrvHandlerGenericIdentWriteAIVI::dia_SrvHandlerGenericIdentWriteAIVI(tCString name, tU8 sid, tU16 did):
dia_SrvHandlerGenericIdentWrite(name,sid,did) {
	// TODO Auto-generated constructor stub
	dia_tclFnctTrace oTrace("dia_SrvHandlerGenericIdentWriteAIVI::dia_SrvHandlerGenericIdentWriteAIVI(tCString,tU8,tU16)");
}

dia_SrvHandlerGenericIdentWriteAIVI::~dia_SrvHandlerGenericIdentWriteAIVI() {
	// TODO Auto-generated destructor stub
	DIA_TR_INF("dia_SrvHandlerGenericIdentWriteAIVI::~dia_SrvHandlerGenericIdentWriteAIVI()");
}


void dia_SrvHandlerGenericIdentWriteAIVI::vProcessRequest ( const std::vector<void*>& vecArgs )
{
	dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWriteAIVI::vProcessRequest");

    tDiaResult retCodePDConfig=consistencyCheckSupported();
    switch(retCodePDConfig)
    {
       case DIA_FAILED:{
    	   dia_SrvHandlerGenericIdentWrite::vProcessRequest(vecArgs);
       }
    	   break;
       case DIA_SUCCESS:{
    		tDiaResult retCodeCDConfig = DIA_FAILED;
	 //extract the property Id
	 tU32 propID = (tU32) vecArgs[0];
     // length of buffer
	 tU16 size=oDiagMsgBuffer().u16GetDataLength();
	
	 tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
	
	 std::vector<tU8> vec;
	 for ( int i =(size-PROP_LENGTH) ; i <=size-1; ++i )		//iterating the buffer to fetch 64 bytes of data
	 {
	       vec.push_back(pU8[i]);
	 }
	 
	 tU8  oem_type = 0xFF;
	 std::vector<tU8> CMvariantCoding;
	 tU16 length = dia_getPropertySize(DIA_PROP_CM_VARIANT_CODING);
	 CMvariantCoding.reserve(length);

	 tDiaResult retCode = dia_getProperty(DIA_PROP_CM_VARIANT_CODING,CMvariantCoding);
	 if ( retCode == DIA_SUCCESS )
	 {
	     DIA_TR_INF("Reading CMVariant coding is successful");

	     if(length == CMvariantCoding.size())
	      {
	        oem_type = CMvariantCoding[3];
	        DIA_TR_INF("CMVariant coding OEm Type is %d", oem_type);
	        switch(propID){

	        case DIA_PROP_AIVI_VEHICLE_INFO:{
	        	//CD Config Records for Vehicle Info(DID DAB0)
	        	 tU8 CAN_Slot = vec[15];
	        	 tU8 PowerPlatform=tU8(vec[14]&0x7);
	        	 //tU8 CAN_Activation=tU8(vec[16]>>7);

	        	 switch(oem_type){
	        	 case DIA_U8_OEM_TYPE_NISSAN:{
	        	 if(((CAN_Slot==DIA_EN_SLOT_0)||(CAN_Slot==DIA_EN_SLOT_1)||(CAN_Slot==DIA_EN_SLOT_4)||(CAN_Slot==DIA_EN_SLOT_5)||(CAN_Slot==DIA_EN_SLOT_6))&&
	             ((PowerPlatform==DIA_EN_PLATFORM_0)||(PowerPlatform==DIA_EN_PLATFORM_1)||(PowerPlatform==DIA_EN_PLATFORM_2)||(PowerPlatform==DIA_EN_PLATFORM_3)||(PowerPlatform==DIA_EN_PLATFORM_6)||(PowerPlatform==DIA_EN_PLATFORM_7)))
	        	 //(CAN_Activation==DIA_U8_MESSAGE_TYPE_NISSAN))
	        	  {
	        		DIA_TR_INF("Permitted values for Nissan::Power Platform=%d,CAN_Slot=%d",PowerPlatform,CAN_Slot);
    		        		retCodeCDConfig = DIA_SUCCESS;
	        	  }
	        	 else
	        	  {
	        	 	DIA_TR_INF("Non Permitted values for Nissan::Power Platform=%d,CAN_Slot=%d",PowerPlatform,CAN_Slot);
    		        	 	retCodeCDConfig=DIA_FAILED;
	        	  }
	        	 }
	          	 break;
	        	 case DIA_U8_OEM_TYPE_RENAULT:{
	        	 if(((CAN_Slot==DIA_EN_SLOT_0)||(CAN_Slot==DIA_EN_SLOT_1)||(CAN_Slot==DIA_EN_SLOT_2)||(CAN_Slot==DIA_EN_SLOT_3))&&
	        	 ((PowerPlatform==DIA_EN_PLATFORM_0)||(PowerPlatform==DIA_EN_PLATFORM_4)||(PowerPlatform==DIA_EN_PLATFORM_5)))
	        	 //(CAN_Activation==DIA_U8_MESSAGE_TYPE_RENAULT))
	        	  {
	        	    DIA_TR_INF("Permitted values for Renault::Power Platform=%d,CAN_Slot=%d",PowerPlatform,CAN_Slot);
    		                retCodeCDConfig = DIA_SUCCESS;
	        	  }
	        	 else
	        	  {
	        	    DIA_TR_INF("Non Permitted values for Renault::Power Platform=%d,CAN_Slot=%d",PowerPlatform,CAN_Slot);
    		        	    retCodeCDConfig=DIA_FAILED;
	        	  }
	        	 }
	        	 break;
	        	 case DIA_U8_OEM_TYPE_INFINITI:{
	        	 if(((CAN_Slot==DIA_EN_SLOT_0)||(CAN_Slot==DIA_EN_SLOT_1)||(CAN_Slot==DIA_EN_SLOT_4)||(CAN_Slot==DIA_EN_SLOT_5)||(CAN_Slot==DIA_EN_SLOT_6))&&
	        	 ((PowerPlatform==DIA_EN_PLATFORM_0)||(PowerPlatform==DIA_EN_PLATFORM_1)||(PowerPlatform==DIA_EN_PLATFORM_2)||(PowerPlatform==DIA_EN_PLATFORM_3)||(PowerPlatform==DIA_EN_PLATFORM_6)))
	        	  {
	        	    DIA_TR_INF("Permitted values for Infiniti::Power Platform=%d,CAN_Slot=%d",PowerPlatform,CAN_Slot);
    		        	    retCodeCDConfig = DIA_SUCCESS;
	        	  }
	        	 else
	        	  {
	        	 	DIA_TR_INF("Non Permitted values for Infiniti::Power Platform=%d,CAN_Slot=%d",PowerPlatform,CAN_Slot);
    		        	 	retCodeCDConfig=DIA_FAILED;
	        	  }
	        	 }
	        	 break;
	        	 default:{
	        		 DIA_TR_INF("None of the OEM types");
    		        		 retCodeCDConfig = DIA_FAILED;}
	        		 break;
	        	 }

	        }
	        break;
	        case DIA_PROP_AIVI_SYSTEM_INFO_COMMON:{
	        	// CD Config Records for System Info(DID DAB1)
	        	tU8 Brand=tU8(vec[4]&0x7);
	        	tU8 OpeningAnimation=tU8((vec[4]>>3)&0xF);
	        	switch(oem_type){
	            case DIA_U8_OEM_TYPE_NISSAN:{
	            if(((Brand==DIA_EN_BRAND_NISSAN)||(Brand==DIA_EN_BRAND_EV_NISSAN))&&
	            ((OpeningAnimation==DIA_EN_OPENING_ANIMATION_NISSAN)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_EV_NISSAN)))
	             {
	               DIA_TR_INF("Permitted values for Nissan::Brand=%d,OpeningAnimation=%d",Brand,OpeningAnimation);
    		               retCodeCDConfig = DIA_SUCCESS;
	             }
	            else
	             {
	               DIA_TR_INF("Non Permitted values for Nissan::Brand=%d,OpeningAnimation=%d",Brand,OpeningAnimation);
    		               retCodeCDConfig=DIA_FAILED;
	             }
	            }
	            break;
	            case DIA_U8_OEM_TYPE_RENAULT:{
	            if(((Brand==DIA_EN_BRAND_RENAULT)||(Brand==DIA_EN_BRAND_DACIA)||(Brand==DIA_EN_BRAND_DAIMLER)||(Brand==DIA_EN_BRAND_AVTOVAZ)||(Brand==DIA_EN_BRAND_RSM))&&
	            ((OpeningAnimation==DIA_EN_OPENING_ANIMATION_RENAULT)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_RSM)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_GT_LINE)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_INITIALE)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_RS)))
	             {
	               DIA_TR_INF("Permitted values for Renault ::Brand=%d,OpeningAnimation=%d",Brand,OpeningAnimation);
    		               retCodeCDConfig = DIA_SUCCESS;
	             }
	            else
	             {
	               DIA_TR_INF("Non Permitted values for Renault::Brand=%d,OpeningAnimation=%d",Brand,OpeningAnimation);
    		               retCodeCDConfig=DIA_FAILED;
	             }
	            }
	        	break;
	            case DIA_U8_OEM_TYPE_INFINITI:{
	            if(((Brand==DIA_EN_BRAND_INFINITI)||(Brand==DIA_EN_BRAND_NISSAN))&&
	            ((OpeningAnimation==DIA_EN_OPENING_ANIMATION_INFINITI)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_INFINITI_WITH_R)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_INFINITI_SKYLINE)||(OpeningAnimation==DIA_EN_OPENING_ANIMATION_NISSAN)))
	             {
	               DIA_TR_INF("Permitted values for Infiniti::Brand=%d,OpeningAnimation=%d",Brand,OpeningAnimation);
    		               retCodeCDConfig = DIA_SUCCESS;
	             }
	            else
	             {
	           	   DIA_TR_INF("Non Permitted values for Infiniti::Brand=%d,OpeningAnimation=%d",Brand,OpeningAnimation);
    		           	   retCodeCDConfig=DIA_FAILED;
	           	 }
	            }
	            break;
	            default:{
	        	  DIA_TR_INF("None of the OEM types");
    		        	  retCodeCDConfig = DIA_FAILED;}
	        	break;
	         }

	        }
	        break;
	        default:{
	        	 DIA_TR_INF("None of the permitted property for consistency check");
    		        	 retCodeCDConfig=DIA_FAILED;
    		  		    }
	  	         break;
	        }

	      }
	       else
	       {
	         DIA_TR_INF("CMVariant coding length is not same as configured %d", length);
	         retCode = DIA_FAILED;
	       }
	   }
	   else
	   {
	     DIA_TR_INF("UNABLE TO READ ITEM (CMVariant coding) !!");
		 retCode = DIA_FAILED;
	   }

    		 if (retCodeCDConfig == DIA_SUCCESS){
		 dia_SrvHandlerGenericIdentWrite::vProcessRequest(vecArgs);
	 }
	 else{
		 vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));}
       }
      break;
       default:{
    	   vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));}
      break;
    }
}
tDiaResult dia_SrvHandlerGenericIdentWriteAIVI::consistencyCheckSupported()
{
	dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWriteAIVI::supportConsistencyCheck");
	tU8 configData[DIA_AIVI_VARIANT_CODING_LENGTH] = {0};
	tDiaResult retCode=dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, configData, DIA_AIVI_VARIANT_CODING_LENGTH);
	if(retCode!=DIA_SUCCESS)
	{
		DIA_TR_ERR("##### AIVI VARIANT CODING NOT AVAILABLE !!! #####");
		return retCode;
	}
	else
	{
		DIA_TR_INF("Reading AIVI Variant coding is successful");
		tU8 consistency_check_support=tU8(configData[3]>>2);
		if(consistency_check_support==CONSISTENCY_CHECK_SUPPORT_DEFAULT)
		{
			   DIA_TR_INF("####Consistency check is not required!!!!");
			   return DIA_FAILED;
		}
		else
		{
			   DIA_TR_INF("####Consistency check is required!!!!");
			   return DIA_SUCCESS;
		}
	}
}
