/*
 * dia_SrvHandlerGenericIOCtrlByIdentifierIVI.cpp
 *
 *  Created on: 20.08.2015
 *      Author: nbs3kor
 */

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include <common/framework/engine/dia_LookupKey.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_MANAGER__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

// include own class
#include "dia_SrvHandlerGenericIOCtrlByIdentifierIVI.h"


using namespace std;

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIOCtrlByIdentifierIVI::dia_SrvHandlerGenericIOCtrlByIdentifierIVI ( void )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericIOCtrlByIdentifierIVI::dia_SrvHandlerGenericIOCtrlByIdentifierIVI()");
#endif
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericIOCtrlByIdentifierIVI::~dia_SrvHandlerGenericIOCtrlByIdentifierIVI ( void )
{

}

//------------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericIOCtrlByIdentifierIVI::shortTermAdjustment ( dia_IOCtrlSignal& signal )
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericIOCtrlByIdentifierIVI::shortTermAdjustment(signal)");

   tDiaResult retCode = DIA_SUCCESS;

   tU8  payloadOffset = 0;
   tU8  timerValue    = 0xFF;
   tU16 dataLength    = oDiagMsgBuffer().u16GetDataLength();

   if ( signal.getMonitoringMode() != DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED )
   {
	  timerValue    = 20; //20 sec
      payloadOffset = 1;
   }

   // copy ctrlValue data from received message to vector
   std::vector<tU8> ctrlValue;

   for ( tU16 i = DIA_C_U16_IOCTRL_PAYLOAD_START_BYTE; i < dataLength; i++ )
   {
      ctrlValue.push_back(oDiagMsgBuffer().u8GetData(i));
    }

//   DIA_TR_INF("---- shortTermAdjustment ctrlValue.size() = %d!!", ctrlValue.size());
//   for ( tU16 j = 0; j < ctrlValue.size(); j++ )
//   {
//       //ctrlValue.push_back(oDiagMsgBuffer().u8GetData(i));
//       DIA_TR_INF("---- shortTermAdjustment ctrlValue.at(j) = %d!!", j, ctrlValue.at(j));
//   }

   if ( signal.checkPayloadCorrectness((dataLength + payloadOffset),&ctrlValue) != DIA_SUCCESS )
   {
      // Prints are send in checkPayloadCorrectness
      retCode = DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
   }
   else
   {
      // check if the signal was frozen before
      if ( signal.isFrozen() )
      {
         retCode = mpIOCtrlMgr->shortTermAdjustment(signal,timerValue,&ctrlValue);
         if ( retCode == DIA_SUCCESS && signal.isResultReady() )
         {
            mpIOCtrlMgr->removeIOControlListener(signal.getUID(),this);
            vSendIOCtrlPositiveResponse(signal,mCtrlState,timerValue,&ctrlValue);
         }
      }
      else
      {
         // signal was not frozen before. send sequence error
         DIA_TR_INF("SIGNAL NOT FROZEN !!");
         retCode = DIA_E_SEQUENCE_ERROR;
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericIOCtrlByIdentifierIVI::vSendIOCtrlPositiveResponse (
      dia_IOCtrlSignal& signal,
      tU8 ctrlState1,
      tU8 /*timerValue*/,         // optional: only for short time adjustment
      const vector<tU8>* ctrlValue  // optional: only for short time adjustment
      )
{
   if ( !mpIOCtrlMgr ) return;

   if ( mIsDone )
   {
      DIA_TR_INF("dia_SrvHandlerGenericIOCtrlByIdentifierIVI::vSendIOCtrlPositiveResponse: Response Was Already Sent. Done. !!!!!");
      return;
   }

   tU16 subID = signal.getDID();

   if ( subID != 0xFFFF )
   {
      // results for this request
      vector<tU8> results;
      results.push_back(static_cast<tU8>(subID >> 8));
      results.push_back(static_cast<tU8>(subID));
      results.push_back(ctrlState1);

      switch ( ctrlState1 )
      {
      case DIA_C_U8_UDS_IOCTRL_RESET_OR_INIT:
         DIA_TR_INF("dia_SrvHandlerGenericIOCtrlByIdentifierIVI::vSendIOCtrlPositiveResponse: DIA_C_U8_UDS_IOCTRL_RESET_OR_INIT (YOU_SHOULD_NEVER_SEE_THIS_TRACE) !!!!!");
         // not implemented yet. we should never arrive at this point
         return;

      case DIA_C_U8_UDS_IOCTRL_SHORT_TERM_ADJUSTMENT:
         {
//            if ( signal.getMonitoringMode() != DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED )
//            {
//               results.push_back(timerValue);
//            }

            if ( ctrlValue )
            {
               for ( tU16 i=0; i<ctrlValue->size(); i++ )
               {
                  results.push_back(ctrlValue->at(i));
               }
            }
         }
         break;

      case DIA_C_U8_UDS_IOCTRL_FREEZE_CURRENT_STATE:
      case DIA_C_U8_UDS_IOCTRL_RETURN_CTRL_TO_ECU:
         {
            signal.getCurrentState(results);
         }
         break;

      default:
         // Ouups. we should never arrive at this point
         return;
      }

      vSendPositiveResponse(static_cast<tU16>(results.size() + 1), &results);
      mIsDone = true;
   }
}
