
#ifndef __DIA_SRV_HANDLER_COMPONENTS_SOFTWARE_VERSION_H__
#define __DIA_SRV_HANDLER_COMPONENTS_SOFTWARE_VERSION_H__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif
#include <vector>
namespace tinyxml2 
{
	class XMLElement;
	class XMLNode;
}
using namespace tinyxml2;
namespace dia {

/**
 * \class   dia_SrvHandlerComponentsSWVersionInfo
 *
 * \brief   service handler to process read request for
 *			reading AllComponentSoftware name and Version of CIS Installation Container
 *
 * \ingroup diaServicesproj
 */
class dia_SrvHandlerComponentsSWVersionInfo
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerComponentsSWVersionInfo);

public:
   dia_SrvHandlerComponentsSWVersionInfo(tCString name, tU8 sid, tU16 did);
   
   std::vector<tU8> vcSWElementName;
   std::vector<tU8> vcSWElementVersion;
   std::vector<tU8> vcSWElementVersion_final;
   virtual ~dia_SrvHandlerComponentsSWVersionInfo(void);
   virtual void vProcessRequest ( const std::vector<void*>&  /* vecArgs */);

private:
    /**
    *
    * \brief      method called to parse xml
    *
    *             This method is used to parse the xml file.
    *             
    * \param[in]  file      xml file path
    *
    * \return     none
    */
	virtual void parseXML( const std::string& /* file */); 
    /**
    *
    * \brief      member variable to store ComponentSW version value
    *
    */
	std::string __ComponentsSoftwareVersion;
    /**
    *
    * \brief      member variable to store ComponentSW version name
    *
    */
	std::string __ComponentsSWVersionElementName;
   /**
    *
    * \brief      member variable to store parsing result
    *
    */
   tBool __ComponentsSoftwareVersionFound;
};

} /* namespace dia */

#endif /* __DIA_SRV_HANDLER_COMPONENTS_SOFTWARE_VERSION_H__ */
