#include <iostream>
#include <string>
#include <vector>
#include <iterator>
#ifndef __DIA_SRV_HANDLER_COMPONENTS_SOFTWARE_VERSION_H__
#include "project/services/customer/dia_SrvHandlerComponentsSWVersionInfo.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#include <sstream>
#include <common/framework/xml/tinyxml2.h>

using namespace tinyxml2;

namespace dia {

#define DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))
#define DATA_LENGTH                             ((tU16) (500))

static const std::string targetXMLpath  ("/var/opt/bosch/persistent/fcswupdate/doipcmcupdateresult.xml");
static const std::string targetNodeName ("node");
static const std::string defaultComponentSWVersion ("000000");
static const std::string defaultComponentSWVersionElementName ("none");

//------------------------------------------------------------------------------

dia_SrvHandlerComponentsSWVersionInfo::dia_SrvHandlerComponentsSWVersionInfo ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name, sid, did),
     __ComponentsSoftwareVersion(defaultComponentSWVersion),
     __ComponentsSWVersionElementName(defaultComponentSWVersionElementName),
     __ComponentsSoftwareVersionFound(FALSE)
{
   dia_tclFnctTrace trc("dia_SrvHandlerComponentsSWVersionInfo::dia_SrvHandlerComponentsSWVersionInfo(tCString,tU8,tU16)");
}

//------------------------------------------------------------------------------

dia_SrvHandlerComponentsSWVersionInfo::~dia_SrvHandlerComponentsSWVersionInfo ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandlerComponentsSWVersionInfo::vProcessRequest ( const std::vector<void*>& vecArgs )
{  
   dia_tclFnctTrace trc("dia_SrvHandlerComponentsSWVersionInfo::vProcessRequest(...)");
   
   //fetch customer version string
   tU32 propID_ecu_sw_version = DIA_PROP_CM_ECU_SW_BUILD_VERSION;
   std::vector<tU8> ecu_sw_version_number;
   vcSWElementVersion_final.clear();
   if ((dia_getProperty(propID_ecu_sw_version, ecu_sw_version_number)) == DIA_SUCCESS)
   {
      DIA_TR_INF("LENGTH OF ACTUAL CUSTOMER VERSION STRING = %zu", ecu_sw_version_number.size());
      for (tU16 u16Count = 0; u16Count < ecu_sw_version_number.size() - 1; u16Count++)
      {
         vcSWElementVersion_final.push_back(ecu_sw_version_number[u16Count]);
         DIA_TR_INF(" ACTUAL CUSTOMER VERSION STRING = %du", vcSWElementVersion_final[u16Count]);
      }
   }
   //seperator added
   vcSWElementVersion_final.push_back('_');

   //fetch build version and concatenate the build version label to customer version string
   __ComponentsSoftwareVersion = defaultComponentSWVersion;
   __ComponentsSWVersionElementName = defaultComponentSWVersionElementName;
   __ComponentsSoftwareVersionFound = FALSE;
   parseXML(targetXMLpath);
   if ( !__ComponentsSoftwareVersionFound)
   {
      DIA_TR_ERR("### dia_SrvHandlerComponentsSWVersionInfo::vProcessRequest error detected!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   else
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH + vcSWElementVersion_final.size()));
      // Fill Response Buffer
      for(int j = 0; j < DATA_LENGTH; j++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READ_DATA_BY_ID_REQUEST_LENGTH + j), vcSWElementVersion_final[j]);
      }
      vResReadyAndQuit();
   }
}

//------------------------------------------------------------------------------
/**
*
* \brief      method called to parse xml
*
*             This method is used to parse the xml file.
*             
* \param[in]  file      xml file path
*
* \return     none
*/
void
dia_SrvHandlerComponentsSWVersionInfo::parseXML ( const std::string& file )
{
   ScopeTrace oTrace("dia::dia_SrvHandlerComponentsSWVersionInfo::parseXML(...)");
   
   XMLDocument xmlDoc;
   XMLError retCode = xmlDoc.LoadFile(file.c_str());
   if(XML_SUCCESS == retCode)
   {
      size_t found = file.find_last_of("/\\");
      std::string FileName = file.substr(found+1);
      std::string FilePath = file.substr(0,found);
      
      DIA_TR_INF("+------------------------------+");
      DIA_TR_INF("| START PARSING OF XML CONTENT |");
      DIA_TR_INF("+------------------------------+");
      DIA_TR_INF("");
      DIA_TR_INF("+ PATH: \"%s\"",FilePath.c_str());
      DIA_TR_INF("+ FILE: \"%s\"",FileName.c_str());
      
      XMLElement* root = xmlDoc.RootElement();
      for( XMLNode* node = root->FirstChild(); node; node = node->NextSibling() )
      {     
         std::string tagName= node->Value();
         if (targetNodeName == tagName)
         {
            DIA_TR_INF("dia_SrvHandlerComponentsSWVersionInfo:  Node Name: \"%s\"", tagName.c_str());
            const char* attributeName =  node->ToElement()->Attribute("name");
            if(attributeName != NULL )
            {
               __ComponentsSWVersionElementName = std::string(attributeName);
               DIA_TR_INF("ComponentsSWVersionElementName : \"%s\"",__ComponentsSWVersionElementName.c_str());

               tU16 elmentNameLength=__ComponentsSWVersionElementName.length();
               DIA_TR_INF("ComponentsSWVersionElementLength : \"%d\"",elmentNameLength);

               std::vector<tU8> vcSWElementName(__ComponentsSWVersionElementName.begin(), __ComponentsSWVersionElementName.end());

                DIA_TR_INF("vcSWElementVersionName_final.size()=%d",vcSWElementVersion_final.size());
                std::vector<tU8>::iterator ptr1=vcSWElementVersion_final.insert(vcSWElementVersion_final.end(),vcSWElementName.begin(),vcSWElementName.end());
               DIA_TR_INF("vcSWElementVersion_final.size()=%d",vcSWElementVersion_final.size());

               vcSWElementVersion_final.push_back(':');
               DIA_TR_INF("vcSWElementVersion_final.size()=%d",vcSWElementVersion_final.size());
               __ComponentsSoftwareVersionFound = TRUE;
               vcSWElementName.clear();
            }
            else
            {
               DIA_TR_ERR("### dia_SrvHandlerComponentsSWVersionInfo::parseXML Atrribute value Not Found");  
            }
            const char* attributeVersion =  node->ToElement()->Attribute("newSWversion");
            if(attributeVersion != NULL)
            {
               __ComponentsSoftwareVersion = std::string(attributeVersion);
               DIA_TR_INF("ComponentsSWVersion : \"%s\"",__ComponentsSoftwareVersion.c_str());

               tU16 elmentVersionLength=__ComponentsSoftwareVersion.length();
               DIA_TR_INF("ComponentsSWVersionLength: \"%d\"",elmentVersionLength);

               std::vector<tU8> vcSWElementVersion(__ComponentsSoftwareVersion.begin(), __ComponentsSoftwareVersion.end());

               DIA_TR_INF("vcSWElementVersion_final.size()=%d",vcSWElementVersion_final.size());
               std::vector<tU8>::iterator ptr2=vcSWElementVersion_final.insert(vcSWElementVersion_final.end(),vcSWElementVersion.begin(),vcSWElementVersion.end());
               DIA_TR_INF("vcSWElementVersion_final.size()=%d",vcSWElementVersion_final.size());

               vcSWElementVersion_final.push_back(',');
               vcSWElementVersion_final.push_back(' ');
               DIA_TR_INF("vcSWElementVersion_final.size()=%d",vcSWElementVersion_final.size());
               __ComponentsSoftwareVersionFound = TRUE;
                vcSWElementVersion.clear();
            }
            else
            {
            	DIA_TR_ERR("### dia_SrvHandlerComponentsSWVersionInfo::parseXML Atrribute value Not Found");  
            }
         }
         else
         {
            DIA_TR_ERR("### dia_SrvHandlerComponentsSWVersionInfo::parseXML Target Node mismatching--Expected :'node',Observed:%s!",tagName.c_str());
         }
      }
      vcSWElementVersion_final.pop_back();
      vcSWElementVersion_final.pop_back();
   }
   
}

} /* namespace dia */
