/*!
 * \file       dia_SrvHandlerCVBSConnectionStatus.h
 *
 * \brief      Service handler that will read the current CVBS Connection Status
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       11.06.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_CVBS_CONNECTION_STATUS__
#define __INCLUDED_DIA_SRV_HANDLER_RDID_CVBS_CONNECTION_STATUS__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CVBSCONNECTION_LISTENER__
#include "project/interfaces/dia_ICVBSConnectionListener.h"
#endif

class dia_SrvHandlerCVBSConnectionStatus
   : public dia_ServiceHandlerUDS,
     public dia_ICVBSConnectionListenerImpl
{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerCVBSConnectionStatus);
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerCVBSConnectionStatus);

public:
   //! class constructor
   dia_SrvHandlerCVBSConnectionStatus ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandlerCVBSConnectionStatus ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

   //! reply on getting current cvbs connection status
   virtual void vOnCVBSConnectionStatus ( const dia_eCVBSConnectionInfo /*status*/ );

};

#endif /* __INCLUDED_DIA_SRV_HANDLER_RDID_CVBS_CONNECTION_STATUS__ */