/*!
 * \file       dia_SrvHandlerAudioFileCounter.cpp
 *
 * \brief      Service handler that will read the audio file counter Status
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Raksha Rao (RBEI/ECA2)
 *
 * \date       13.09.2021
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_AUDIO_FILE_COUNTER__
#include "project/services/customer/dia_SrvHandlerAudioFileCounter.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 4
//-----------------------------------------------------------------------------

dia_SrvHandlerAudioFileCounter::dia_SrvHandlerAudioFileCounter ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerAudioFileCounter::dia_SrvHandlerAudioFileCounter");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerAudioFileCounter::~dia_SrvHandlerAudioFileCounter ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IMediaFileCounterListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerAudioFileCounter::~dia_SrvHandlerAudioFileCounter !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandlerAudioFileCounter::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerAudioFileCounter::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IMediaFileCounter* pInterface = NULL;
   if ((querySysAdapterInterface<dia_IMediaFileCounter>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IMediaFileCounterListener>(this);

      if (pInterface->mediaFile_noOfFilesCounter_Get() == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_INF("dia_SrvHandlerAudioFileCounter::vProcessRequest - audioFile_noOfFilesCounter_Get() failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandlerAudioFileCounter::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_IMediaFileCounterListener>(this);
      DIA_TR_ERR("dia_SrvHandlerAudioFileCounter ---  SEND TO INTERFACE FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerAudioFileCounter::vOnAudioFile_noOfFilesCounter_Get (tU32 noOfAudioFiles)
{
   dia_tclFnctTrace trc("dia_SrvHandlerAudioFileCounter::vOnAudioFile_noOfFilesCounter_Get");

   DIA_TR_INF("dia_SrvHandlerAudioFileCounter:: Audio File Counter Received: %d ", noOfAudioFiles );

   tU32 AudioFileCounter = 0;
   (void) unsetSysAdapterListener<dia_IMediaFileCounterListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
   AudioFileCounter= noOfAudioFiles;

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, (AudioFileCounter >> 24) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, (AudioFileCounter >> 16) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 2, (AudioFileCounter  >> 8) & 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 3, (AudioFileCounter  >> 0) & 0xFF); 

   vResReadyAndQuit();
}