/*!
 * \file       dia_RtCtrlSelfDiagnosis.h
 *
 * \brief      service handler for routine control Self Diagnosis
 *
 * \details    this service sends trigger to external ECUs to start SelfDiagnosis
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesProject
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SELF_DIAGNOSIS__
#define __INCLUDED_DIA_ROUTINE_CTRL_SELF_DIAGNOSIS__

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS_LISTENER__
#include <common/interfaces/dia_ISystemSettingsListener.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif


class dia_RtCtrlSelfDiagnosis
   : public dia_Routine,
     public dia_ISystemSettingsListener
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RtCtrlSelfDiagnosis);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RtCtrlSelfDiagnosis);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return 60000; } //upasna -- 60sec???

   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );

   virtual void onSystemSettingProcessed ( dia_UID typeID, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, void* cookie );
};

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_SELF_DIAGNOSIS__ */
