/*
 * dia_RoutineCtrlSystemInstallation.h
 * brief:Implementation of Routine service to execute SystemInstallation.
 * Created on: May 15, 2019
 * Author: urm7kor
 * copyright  (c) 2017 Robert Bosch GmbH
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SYSTEM_INSTALLATION_H__
#define __INCLUDED_DIA_ROUTINE_CTRL_SYSTEM_INSTALLATION_H__
#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EXECUTE_SYSTEM_COMMAND__
#include <common/services/uds/generic/dia_RoutineCtrlExecuteSystemCommand.h>
#endif

namespace tinyxml2
{
	class XMLElement;
	class XMLNode;
}
using namespace tinyxml2;

namespace dia
{
class dia_RoutineCtrlSystemInstallation
	: public RoutineCtrlExecuteSystemCommand
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlSystemInstallation);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlSystemInstallation);

   public:
   virtual tU32 getMaxProcessingTime ( void ) const { return 60000; }
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   protected:
   //! populate the argument vector with command line arguments
   virtual tDiaResult getCommandArguments ( std::vector<std::string>& /*argv*/);
   //! overloaded method, because bash script is called (not binary application)
   virtual bool isExisting ( void );
   virtual void startSystemCommand ( void );
   bool InStartRoutine; //To check whether Routine request is for start/result.
   private:
      /**
       *
       * \brief      method called to parse xml
       *
       *             This method is used to parse the xml file.
       *
       * \param[in]  file      xml file path
       *
       * \return     none
       */
   	virtual void parseXML( const std::string& /* file */ );
      /**
       *
       * \brief      member variable to store parsed string
       *
       */
   	std::string CISSytemInstallationStatusResult;

};
}
#endif /* DIA_ROUTINECTRLSYSTEMINSTALLATION_H_ */
