/*
 * dia_RoutineCtrlReloadSupplierDeliveryState.cpp
 * Brief Description: Routine Service handler will copy default config data item into current config data item
 * Created on: Aug 28, 2019
 * Author: URM7KOR
 */

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include "common/framework/test/dia_TestController.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetManager.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFAULT_CONFIGURATION__
#include "project/framework/config/dia_DefaultConfiguration.cpp"
#endif

#include "project/services/customer/dia_EcuResetConfigToDeliveryState.h"
#include "project/services/customer/dia_ReadSupportedLocalIdentifiers.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif
#include "dia_RoutineCtrlReloadSupplierDeliveryState.h"


namespace dia
{

dia_RoutineCtrlReloadSupplierDeliveryState::dia_RoutineCtrlReloadSupplierDeliveryState( void )
: dia_Routine("dia_RoutineCtrlReloadSupplierDeliveryState", DIA_C_U16_DID_CENTER_CMC_19_RELOAD_SUPPLIER_DELIVERY_STATE, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlReloadSupplierDeliveryState::dia_RoutineCtrlReloadSupplierDeliveryState");
}
//--------------------------------------------------------------------------------------
dia_RoutineCtrlReloadSupplierDeliveryState::~dia_RoutineCtrlReloadSupplierDeliveryState() {
	DIA_TR_INF("dia_RoutineCtrlReloadSupplierDeliveryState::~dia_RoutineCtrlReloadSupplierDeliveryState");

}
//----------------------------------------------------------------------------------------------
tDiaResult
dia_RoutineCtrlReloadSupplierDeliveryState::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlReloadSupplierDeliveryState::start");
	tDiaResult  retCode         = DIA_FAILED;

	// prepare processing of the routine
	vInitialize();
	const dia_ConfigToDeliveryInfo *pConfigToDeliveryRep = dia_DefaultConfiguration::getConfigToDeliveryRep();
	tU32 u32ConfigSize = dia_DefaultConfiguration::getConfigToDeliveryRepSize();
	DIA_TR_INF( "dia_RoutineCtrlReloadSupplierDeliveryState->ConfigSize is:%d",u32ConfigSize);
	tU32 i;
	for ( i = 0; i < u32ConfigSize; i++)
	{
		tU32 currProp = pConfigToDeliveryRep[i].mCurrentProp;
		retCode = setDefaultConfigItem(currProp, pConfigToDeliveryRep[i].mDefaultProp);

		if (retCode == DIA_FAILED)
		{
			DIA_TR_ERR( "dia_RoutineCtrlReloadSupplierDeliveryState::handleRequest: item %d (decimal) FAILED", i);
			break;
		}
	}
	if (retCode != DIA_FAILED)
	{
		DIA_TR_INF("dia_RoutineCtrlReloadSupplierDeliveryState::start - Successfull !!!");
		eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
	}
	else
	{
		DIA_TR_INF("dia_RoutineCtrlReloadSupplierDeliveryState::start - UnSuccessfull !!!");
		eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
	}
	mIsResultReady = TRUE;
	return retCode;
}
//--------------------------------------------------------------------------
tDiaResult
dia_RoutineCtrlReloadSupplierDeliveryState::requestResult ( std::vector<tU8>& results )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlReloadSupplierDeliveryState::requestResult()");

	results.push_back(mapStatus2UDSResult());
	results.insert(results.end(), mResults.begin(), mResults.end());

	return DIA_SUCCESS;
}
//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlReloadSupplierDeliveryState::setDefaultConfigItem(tU32 currentItemID, tU32 defaultItemID) const
{
	std::vector<tU8> data(4096, 0);

	if (DIA_SUCCESS!=readConfigItem(data, defaultItemID))
	{
		DIA_TR_ERR("dia_RoutineCtrlReloadSupplierDeliveryState::setDefaultConfigItem: readConfigItem FAILED!!");
		return DIA_FAILED;
	}

	if (DIA_SUCCESS!=writeConfigItem(data, currentItemID))
	{
		DIA_TR_ERR("dia_RoutineCtrlReloadSupplierDeliveryState::setDefaultConfigItem: writeConfigItem FAILED!!");
		return DIA_FAILED;
	}

	return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlReloadSupplierDeliveryState::readConfigItem(std::vector<tU8>& data, tU32 id) const
{
	tDiaResult retCode =  dia_getProperty(id, data);

	if(DIA_SUCCESS != retCode)
	{
		DIA_TR_ERR("dia_RoutineCtrlReloadSupplierDeliveryState::readConfigItem: item 0x%08X FAILED !!", id);
	}

	return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlReloadSupplierDeliveryState::writeConfigItem(const std::vector<tU8>& data, tU32 id) const
{
	dia_ConfigManager* pConfMgr = getInstanceOfConfigManager();

	if(0 == pConfMgr)
	{
		DIA_TR_ERR("dia_RoutineCtrlReloadSupplierDeliveryState::writeConfigItem pConfMgr NULL ptr");
		return DIA_FAILED;
	}

	if(DIA_SUCCESS != pConfMgr->setProperty(id, data))
	{
		DIA_TR_ERR("dia_RoutineCtrlReloadSupplierDeliveryState::writeConfigItem: item 0x%08X FAILED !!", id);
		return DIA_FAILED;
	}

	return DIA_SUCCESS;
}

}//namespace dia
