/*!
 * \file       dia_RoutineCtrlIdentifySubSystem.h
 *
 * \brief      Service handler that will list out all the possible subsystems connected
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Rajesh Kumar(RBEI/ECA2), Arjun Manjunath Sanu (RBEI/ECA2), Kirty Mayank (RBEI/ECA2)
 *
 * \date       30.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ROUTINE_IDENTIFY_SUBSYSTEM_H_
#define __INCLUDED_DIA_ROUTINE_IDENTIFY_SUBSYSTEM_H_

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CMC_DOIP_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif

class dia_RoutineCtrlIdentifySubSystem
	: public dia_Routine,
	  public dia_ISubsystemDiagnosisListenerImpl,
	  public dia_ISessionListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlIdentifySubSystem);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlIdentifySubSystem);

   public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue = DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class

   virtual tDiaResult requestResult  ( std::vector<tU8>& results );
   virtual tDiaResult requestResult  ( void ) override ;
   
   //! called by the session control object to notify about a session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );

   protected:
   
   //! Extract the received subsytems node information and populate the vector
   virtual void vExtractAndFillNodeData(const std::list<dia_tSubsystemInfo>&);
   //! there was an update in the identified subsystems
   virtual void vOnIdentifySubsystemsRequestUpdate (const std::list<dia_tSubsystemInfo>& , dia_eIdentifyEntitiesRoutineStatus /* status */);
   //! register for session changes
   virtual tDiaResult registerSessionChange( void );
   //! unregister for session changes
   virtual tDiaResult unregisterSessionChange( void );
   
   static const std::map<const dia_eIdentifyEntitiesRoutineStatus, const dia_eRoutineStatus> _IdentifyEntity_RoutineStatus_Map;
   
   private:
   
   bool _started;

};
#endif /* __INCLUDED_DIA_ROUTINE_IDENTIFY_SUBSYSTEM_H_ */
