/*
 * dia_RoutineCtrlCopyInstallationLogFileToUSB.h
 * brief:Implementation of copying CIS Installation Logfile from target to USB.
 * component:Diagnosis
 * Created on: May 30, 2019
 * Author: urm7kor
 * copyright  (c) 2017 Robert Bosch GmbH
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_COPY_INSTALLATION_LOG_FILE_TO_USB_H__
#define __INCLUDED_DIA_ROUTINE_CTRL_COPY_INSTALLATION_LOG_FILE_TO_USB_H__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

namespace dia
{
class dia_RoutineCtrlCopyInstallationLogFileToUSB
: public dia_Routine
  {
	DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlCopyInstallationLogFileToUSB);
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlCopyInstallationLogFileToUSB);
  public:
	//! start the specified routine
	virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE );
	//! return control back to the ECU for the specified signal
	virtual tDiaResult requestResult ( std::vector<tU8>& results );
	virtual tU32 getMaxProcessingTime ( void ) const { return 60000; }
  protected:
	bool InStartRoutine; //To check whether Routine request is for start/result.
  };
}//namespace dia

#endif /* DIA_ROUTINECTRLCOPYINSTALLATIONLOGFILETOUSB_H_ */
