/*!
 * \file       dia_RoutineCtrlCheckReprogrammingDtc.h
 *
 * \brief      Trigger corresponding test for a specific DTC, update DTC status and get it back.
 *
 * \details    This routine is implemented for all DTCs concerning logical blocks from 00 to 08
 *             (9 logical blocks x 3 failure types = 27 DTCs).
 *             Test of logical blocks which belongs to Audio component are triggered by DiagLog process:
 *             Step 1. Register for active DTC.
 *             Step 2. Clear DTC (group: reprogramming DTC, only specific DTC).
 *             ..... wait for reply from DiagLog
 *             Step 3. Callback vOnFailedDTCList (request status of a specific DTC)
 *             Step 4. Callback vOnReadStatusByDTCResult
 *
 * \component  Diagnosis
 *
 * \ingroup    Routine Control for the customer
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_ROUTINECTRLCHECKREPROGRAMMINGDTC_H_
#define DIA_ROUTINECTRLCHECKREPROGRAMMINGDTC_H_

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include <common/interfaces/dia_IErrorLogListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_NOTIFICATION_LISTENER__
#include "project/interfaces/dia_IErrorLogNotificationListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif
enum dia_e_logical_block
{
   DIA_LOGICAL_BLOCK_00 = 0xFD00,
   DIA_LOGICAL_BLOCK_01 = 0xFD01,
   DIA_LOGICAL_BLOCK_02 = 0xFD02,
   DIA_LOGICAL_BLOCK_03 = 0xFD03,
   DIA_LOGICAL_BLOCK_04 = 0xFD04,
   DIA_LOGICAL_BLOCK_05 = 0xFD05,
   DIA_LOGICAL_BLOCK_06 = 0xFD06,
   DIA_LOGICAL_BLOCK_07 = 0xFD07,
   DIA_LOGICAL_BLOCK_08 = 0xFD08,
   DIA_LOGICAL_BLOCK_09 = 0xFD09,
   DIA_LOGICAL_BLOCK_10 = 0xFD0A,
   DIA_LOGICAL_BLOCK_11 = 0xFD0B,
   DIA_LOGICAL_BLOCK_12 = 0xFD0C,
   DIA_LOGICAL_BLOCK_13 = 0xFD0D,
   DIA_LOGICAL_BLOCK_14 = 0xFD0E
};

class dia_RoutineCtrlCheckReprogrammingDtc
   : public dia_Routine,
     public dia_IErrorLogListenerImpl,
     public dia_IErrorLogNotificationListenerImpl,
     public dia_ITimerListener
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlCheckReprogrammingDtc);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlCheckReprogrammingDtc);

protected:
   //! if false, calculated hash and executed hashes don't match (last byte in the response)
   tBool mAreHashesMatching;

   //! last DTC to be checked (needed in case of algorithm failure and audio block)
   tU32 mLastDTCNumber;
   //! status of last DTC to be checked (needed in case of algorithm failure and audio block)
   tU8 mLastDTCStatus;

   //! map of logical block (0xFD00 to 0xFD08) and pair properties (data, digest).
   const std::map<dia_e_logical_block,std::pair <tU32,tU32> >& mMapPairDataDigests;

   dia_Timer mTimer;
   tU8 mTimerCount;

   static dia_IErrorLogNotification* pErrorLogNotification;

private:

   tDiaResult setITC(tU16 itc, bool IsDtcPassed);

   tDiaResult clearDTC(tU32 dtc);

public:

   dia_RoutineCtrlCheckReprogrammingDtc(tCString name, tU16 udsID, const std::map<dia_e_logical_block, std::pair <tU32,tU32> >& mapPairDataDigest);

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );
   virtual tU32 getMaxProcessingTime ( void ) const { return DIA_C_U32_ROUTINE_CONTROL_MAX_PROCESSING_TIME_DEFAULT; }
   virtual void vOnTimerElapsed ( dia_TimerID id );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IErrorLogListenerImpl methods
   //
   //-------------------------------------------------------------------------
   //! call back for setITC
   virtual void vOnDiaglogWriteTestResult(void);

   //! call back for setITC
   virtual void vOnDiaglogWriteTestError(const tU32 errCode );

   //! call back for clearDTC - positive response on clearing the fault memory
   virtual void vOnClearResult();
   //! call back for clearDTC - negative response on clearing the fault memory
   virtual void vOnClearError(tU32 u32Error);

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IErrorLogNotificationListenerImpl methods
   //
   //-------------------------------------------------------------------------
   //! notification for a status change of specific DTC (only one DTC)
   virtual void vOnDtcStatusChanged ( const tU32 DTCNumber, const tU8 DTCStatus );

};

#endif /* DIA_ROUTINECTRLCHECKREPROGRAMMINGDTC_H_ */
