/*
 * dia_RoutineCtrlCheckProgrammingDependencies.h
 *
 *  Created on: 05.01.2017
 *      Author: abe6kor
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHECK_PROGRAMMING_DEPENDENCIES__
#define __INCLUDED_DIA_ROUTINE_CTRL_CHECK_PROGRAMMING_DEPENDENCIES__

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include <common/interfaces/dia_IErrorLogListener.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINECONTROL_LISTENER__
#include "common/interfaces/dia_IRoutineControlListener.h"
#endif


typedef enum
{
   PROG_DEPENDENCY_RESULT_TYPE_UNKNOWN          = 0x00,
   PROG_DEPENDENCY_RESULT_TYPE_COMPLETED_OK     = 0x01,
   PROG_DEPENDENCY_RESULT_TYPE_COMPLETED_NOK    = 0x02,
   PROG_DEPENDENCY_RESULT_TYPE_ABORTED          = 0x03
} ProgrammingDependencyResultType;

class dia_RoutineCtrlCheckProgrammingDependencies
   : public dia_Routine,
     public dia_IErrorLogListenerImpl,
     public dia_IRoutineControlListener,
     public dia_MessageHandler
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlCheckProgrammingDependencies);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlCheckProgrammingDependencies);

private:
   std::map<dia_UID, bool> mRoutineResults;
   std::vector<tU32> m_u32logicalBlockIdDTC;
   std::vector<tU32>::const_iterator m_itLogicalBlockIdDTC;

   tDiaResult getDTCbyStatusMask(tU8 u8mask);
   tDiaResult runDTCTest(tU32 u32DTC);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return 2*DIA_C_U32_ROUTINE_CONTROL_MAX_PROCESSING_TIME_DEFAULT; }

   virtual void vOnServiceTimeout ( void );
   //! dia_IErrorLogListenerImpl
   virtual void vOnReadDTCbyStatusMaskResult ( const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList );
   //! call back for clearDTC - positive response on clearing the fault memory
   virtual void vOnClearResult();
   //! dia_IRoutineControlListener
   virtual void vOnRoutineUpdate ( dia_Routine& routine );

};

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_CHECK_PROGRAMMING_DEPENDENCIES__ */

